#!/usr/bin/env perl
use strict;
use warnings;
use FindBin qw( $RealBin );
use lib $RealBin;

#importando as classes:
use Entrada;
use Saida;
use Docente;
use Veiculo;
use Qualificacao;
use Regra;
use Publicacao;
use PublicacaoEmPeriodico;
use PublicacaoEmConferencia;

#codigo da main
my %nomeArquivos = processaEntrada();

#le arquivos csv
my %docentes = Entrada->criaHashDocentes($nomeArquivos{'docentes'});
my %veiculos = Entrada->criaHashVeiculos($nomeArquivos{'veiculos'});
my @publicacoes = Entrada->criaListaPublicacoes($nomeArquivos{'publicacoes'}, \%veiculos, \%docentes);
my @regras = Entrada->criaListaRegras($nomeArquivos{'regras'});
Entrada->leQualificacoes($nomeArquivos{'qualis'}, \%veiculos);

#gera relatorios csv
Saida->geraRelatorio2(\@publicacoes);
Saida->geraRelatorio3(\@publicacoes);


sub processaEntrada {
  my $ARGC = @ARGV;
  my %hash;
  for (my $i = 0; $i < $ARGC; $i++){
    if    ($ARGV[$i] eq "-d") {$hash{"docentes"}    = $ARGV[$i + 1];}
    elsif ($ARGV[$i] eq "-v") {$hash{"veiculos"}    = $ARGV[$i + 1];}
    elsif ($ARGV[$i] eq "-p") {$hash{"publicacoes"} = $ARGV[$i + 1];}
    elsif ($ARGV[$i] eq "-q") {$hash{"qualis"}      = $ARGV[$i + 1];}
    elsif ($ARGV[$i] eq "-r") {$hash{"regras"}      = $ARGV[$i + 1];}
    elsif ($ARGV[$i] eq "-a") {$hash{"ano"}         = $ARGV[$i + 1];}
  }
  return %hash;
}
