package Veiculo;
use Moose;
#use Qualificacao;

has 'sigla' => (is => 'rw', isa => 'Str');
has 'nome' => (is => 'rw', isa => 'Str');
has 'tipo' => (is => 'rw', isa => 'Str');
has 'fatorImpacto' => (is => 'rw', isa => 'Num');
has 'issn' => (is => 'rw', isa => 'Str');
has 'qualificacoes' => (traits  => ['Array'],
                        is => 'rw',
                        isa => 'ArrayRef[Qualificacao]',
                        default => sub { [] },
                        handles => {
                            addQualificacao => 'push',
                            getQualificacoes => 'elements'});
has 'publicacoes' => (traits  => ['Array'],
                      is => 'rw',
                      isa => 'ArrayRef[Publicacao]',
                      default => sub { [] },
                      handles => {
                          addPublicacao => 'push',
                          getPublicacoes => 'elements'});
#lista de publis

sub ehPeriodico {
    my $self = shift;
    if ($self->tipo eq 'P') {return 1;}
    else {return 0;}
}

sub obtemDados {
    my $self = shift;
    my $ano  = $_[0];
    my $qualificacao = $self->obtemQualificacao($ano);
    my $string = $self->sigla . ';' . $self->nome . ';' . $qualificacao->qualis . ';' . sprintf("%.3f", $self->fatorImpacto);
    return $string; 
}

sub obtemQualificacao {
    my $self = shift;
    my $ano  = $_[0];
    my $qualificacao = Qualificacao->new(ano => 0, qualis => '');
    foreach my $q ($self->getQualificacoes){
        if ($qualificacao->ano < $q->ano && $q->ano <= $ano){
            $qualificacao = $q;
        }
    }
    return $qualificacao;
}

1;
