package Saida;
use DateTime;

sub geraRelatorio2 {
    @publicacoes = @{$_[1]};

    open(DATA, ">2-publicacoes.csv") or die "Não foi possivel abrir o arquivo";
    print DATA "Ano;Sigla Veículo;Veículo;Qualis;Fator de Impacto;Título;Docentes\n";

    @publicacoes = sort {$a->titulo cmp $b->titulo} @publicacoes;
    @publicacoes = sort {$a->veiculo->sigla cmp $b->veiculo->sigla} @publicacoes;
    @publicacoes = sort {$b->ano <=> $a->ano} @publicacoes;
    @publicacoes = sort {$a->veiculo->obtemQualificacao($a->ano)->qualis cmp $b->veiculo->obtemQualificacao($b->ano)->qualis} @publicacoes;

    foreach my $p (@publicacoes){
        my $string = $p->obtemDados;
        print DATA "$string\n";
    }

    close (DATA);
}

sub geraRelatorio3 {
    @publicacoes = @{$_[1]};

    open(DATA, ">3-estatisticas.csv") or die "Não foi possivel abrir o arquivo";
    print DATA "Qualis;Qtd. Artigos;Média Artigos / Docente\n";

    @qualis = ('A1', 'A2', 'B1', 'B2', 'B3', 'B4', 'B5', 'C');

    foreach $q (@qualis){
        $numeroArtigos = 0;
        $artigosPorDocente = 0;

        foreach $p (@publicacoes){
            $numeroArtigos += $p->temQualis($q);
            $artigosPorDocente += $p->obtemArtigosPorDocente($q);
        }
        print DATA $q . ';' . $numeroArtigos . ';' . sprintf("%.2f", $artigosPorDocente). "\n";
    }
    close (DATA);
}


1;
