package Publicacao;
use Moose;
use Veiculo;

has 'ano' => (is => 'rw', isa => 'Int');
has 'veiculo' => (is => 'rw', isa => 'Veiculo');
has 'titulo' => (is => 'rw', isa => 'Str');
has 'numero' => (is => 'rw', isa => 'Int');
has 'pagInicial' => (is => 'rw', isa => 'Int');
has 'pagFinal' => (is => 'rw', isa => 'Int');
has 'autores' => (traits  => ['Array'],
                        is => 'rw',
                        isa => 'ArrayRef[Docente]',
                        default => sub { [] },
                        handles => {
                            addAutor => 'push',
                            qtdAutores => 'count',
                            getAutores => 'elements'});

sub obtemDados {
    my $self = shift;
    my $string = $self->ano . ';' . $self->veiculo->obtemDados($self->ano) . ';' . $self->titulo . ';' . $self->obtemNomesAutores;
    return $string;
}
sub obtemNomesAutores {
    my $self = shift;
    my @autores = $self->getAutores;
    my $string = '';
    foreach $a (@autores){
        $string = $string . $a->nome . ',';
    }
    $string = substr $string, 0, -1;
    return $string;
}

sub temQualis {
    my $self = shift;
    my $qualis = $_[0];
    if($self->veiculo->obtemQualificacao($self->ano)->temQualis($qualis)){
        return 1;
    }
    else{
        return 0;
    }
}

sub obtemArtigosPorDocente {
    my $self = shift;
    my $qualis = $_[0];
    if($self->veiculo->obtemQualificacao($self->ano)->temQualis($qualis)){
        return (1/$self->qtdAutores);
    }
    else{
        return 0;
    }
}

1;
