package Entrada;
use DateTime;

sub criaHashDocentes(){
  $arquivo = $_[1];
  %docentes;

  open(DATA, "<$arquivo") or die "Não foi possivel abrir o arquivo";
  $prim = <DATA>;

  while($linha = <DATA>){
    ($codigo, $nome, $dataN, $dataI, $coord) = split '[;\n]', $linha;

    ($dN, $mN, $aN) = split '/', $dataN;
    $dataNascimento = DateTime->new(day => $dN, month => $mN, year => $aN);

    ($dI, $mI, $aI) = split '/', $dataI;
    $dataIngresso = DateTime->new(day => $dI, month => $mI, year => $aI);

    my $coord_bool = ($coord eq "X") ? 1 : 0;
    $docentes{$codigo} = Docente->new(codigo => $codigo,
                                      nome => $nome,
                                      dataNascimento => $dataNascimento,
                                      dataIngresso => $dataIngresso,
                                      coordenador => $coord_bool);
  }
  close(DATA);
  return %docentes;
}

sub criaHashVeiculos{
  $arquivo = $_[1];
  %veiculos;

  open(DATA, "<$arquivo") or die "Não foi possivel abrir o arquivo";
  $prim = <DATA>;

  while($linha = <DATA>){
    ($sigla, $nome, $tipo, $fatorI, $issn) = split '[;\n]', $linha;

    $veiculos{$sigla} = Veiculo->new(sigla => $sigla,
                                      nome => $nome,
                                      tipo => $tipo,
                                      fatorImpacto => $fatorI,
                                      issn => $issn);
    #print "$sigla : $nome : $tipo : $fatorI : $issn \n";
  }

  close(DATA);
  return %veiculos;
}

sub criaListaPublicacoes {
  $arquivo = $_[1];
  %veiculos  = %{$_[2]};
  %docentes = %{$_[3]};
  @publicacoes;

  open(DATA, "<$arquivo") or die "Não foi possivel abrir o arquivo";
  $prim = <DATA>;

  while($linha = <DATA>){
    ($ano, $siglaVeiculo, $titulo, $autores, $numero, $volume, $local, $pagInicial, $pagFinal) = split '[;\n]', $linha;

    $autores =~ s/ //g;
    @vetAutores = split ',', $autores;

    $publicacao;

    if($veiculos{$siglaVeiculo}->ehPeriodico()){
      $publicacao = PublicacaoEmPeriodico->new(ano => $ano,
                                               veiculo => $veiculos{$siglaVeiculo},
                                               titulo => $titulo,
                                               numero => $numero,
                                               pagInicial => $pagInicial,
                                               pagFinal => $pagFinal,
                                               volume => $volume);
    }else {
      $publicacao = PublicacaoEmConferencia->new(ano => $ano,
                                               veiculo => $veiculos{$siglaVeiculo},
                                               titulo => $titulo,
                                               numero => $numero,
                                               pagInicial => $pagInicial,
                                               pagFinal => $pagFinal,
                                               local => $local);
    }

    foreach $a (@vetAutores){
      $docentes{$a}->addPublicacao($publicacao);
      $publicacao->addAutor($docentes{$a});
    }

    $veiculos{$siglaVeiculo}->addPublicacao($publicacao);

    push(@publicacoes, $publicacao);
    #print "$ano, $siglaVeiculo, $titulo, $autores, $numero, $vol, $local, $pagInicial, $pagFinal \n";
  }
  close(DATA);
  return @publicacoes;
}


sub leQualificacoes{
  $arquivo = $_[1];
  %veiculos  = %{$_[2]};

  open(DATA, "<$arquivo") or die "Não foi possivel abrir o arquivo";
  $prim = <DATA>;

  while($linha = <DATA>){
    ($ano, $sigla, $qualis) = split '[;\n]', $linha;

    my $quali = Qualificacao->new(ano => $ano, qualis => $qualis);

    $veiculos{$sigla}->addQualificacao($quali);
    #print "$sigla : $ano : $qualis\n";
  }
  close(DATA);
  return;
}

sub criaListaRegras{
  $arquivo = $_[1];
  @regras;

  open(DATA, "<$arquivo") or die "Não foi possivel abrir o arquivo";
  $prim = <DATA>;

  while($linha = <DATA>){
    ($dataI, $dataF, $listaQualis, $listaPontos, $fatorMult, $qtdAnos, $pontuacaoMinima) = split '[;\n]', $linha;

    ($dI, $mI, $aI) = split '/', $dataI;
    $dataInicio = DateTime->new(day => $dI, month => $mI, year => $aI);

    ($dF, $mF, $aF) = split '/', $dataF;
    $dataFim = DateTime->new(day => $dF, month => $mF, year => $aF);

    my $regra = Regra->new(dataInicio => $dataInicio,
                           dataFim => $dataFim,
                           fatorMult => $fatorMult,
                           qtdAnos => $qtdAnos,
                           pontuacaoMinima => $pontuacaoMinima);

    @qualis = ('A1', 'A2', 'B1', 'B2', 'B3', 'B4', 'B5', 'C');
    @vetQualis = split ',', $listaQualis;
    @vetPontos = split ',', $listaPontos;

    %tabelaPontuacao;
    $pontuacao = 0;
    foreach $q (@qualis){
      if($q eq $vetQualis[0]){
        shift(@vetQualis);
        $pontuacao = shift(@vetPontos);
      }
      $regra->setPontuacao($q => $pontuacao);
    }

    push (@regras, $regra);

  }
  close(DATA);
  return @regras;
}

1;
