package Docente;
use Moose;
use DateTime;

has 'codigo' => (is => 'rw', isa => 'Int');
has 'nome' => (is => 'rw', isa => 'Str');
has 'dataNascimento' => (is => 'rw', isa => 'DateTime');
has 'dataIngresso' => (is => 'rw', isa => 'DateTime');
has 'coordenador' => (is => 'rw', isa => 'Bool');
has 'publicacoes' => (traits  => ['Array'],
                      is => 'rw',
                      isa => 'ArrayRef[Publicacao]',
                      default => sub { [] },
                      handles => {
                          addPublicacao => 'push',
                          getPublicacoes => 'elements'});

=pod
sub new{
	my $class = shift;

	my $self = {
	    codigo => shift,
	    nome => shift,
	    dataNascimento => shift,
	    dataIngresso => shift,
	    coordenador => shift
	    #publicacoes => shift;
	};

	bless($self, $class);
	return $self;
}

sub getNome{
    my $self = shift;
    return $self->{nome};
}

sub getCodigo{
    my $self = shift;
    return $self->{codigo};
}
=cut

1;
