#require File.expand_path("Requires.rb")

def gera_lista_pessoas(map_pessoas) #gera uma lista de pessoas já ordenada pelo nome a partir da map de pessoas.
  lista_pessoas = []
  map_pessoas.each do |codigo, pessoa|
    lista_pessoas = lista_pessoas << pessoa
  end
  lista_pessoas.sort! {|a,b| a.nome.downcase <=> b.nome.downcase}
  
  lista_pessoas.each do |pessoa|
    pessoa.lista_midias.sort
  end
  
  return lista_pessoas
end


def gera_lista_midias(map_midias) #gera uma lista das midias já ordenada pelo nome a partir da map de midias.
  lista_midias = []
  map_midias.each do |codigo, midias|
     lista_midias = lista_midias << midias
  end
  
  lista_midias.sort! {|a,b| a.nome.downcase <=> b.nome.downcase}
  return lista_midias
end


def midias_por_pessoas(lista_pessoas) #gera o relatorio de cada pessoa e sua respectiva lista de midias associadas.
  arq = File.new("pessoas.csv", "w")
  lista_pessoas.each do |pessoa|
    if pessoa.lista_midias != []
      arq.puts "#{pessoa.nome}; #{pessoa.imprime_midias}\n"
    end
  end
  arq.close
end

def wishlist (lista_midias) #gera a wishlist com as ordens de prioridade de ordenação.
  arq = File.new("wishlist.csv", "w")
  lista_midias.sort! {|a,b| if (a.tipo <=> b.tipo) == 0 #se tipo for igual, vai para preço
                              if (a.preco <=> b.preco) == 0 #se preço foi igual, vai pelo nome
                                a.nome <=> b.nome #ordem crescente por nome.
                              else #se preço não for igual, ordem decrescente de preço.
                                if (a.preco <=> b.preco) < 0
                                  a.preco <=> b.preco
                                else
                                  b.preco <=> a.preco
                                end
                              end
                             else #caso tipo nao seja igual, ordem crescente do tipo.
                               a.tipo <=> b.tipo
                             end}   
                                               
   lista_midias.each do |midias| 
     arq.puts "#{midias.tipo}; #{midias.nome}; #{midias.genero}; R$#{midias.preco}\n"
   end
   arq.close
end
