require File.expand_path("Requires.rb")

#função para ler pessoas
def read_pessoas(arq_pessoas)
  map_pessoas = {}
  arq = File.new(arq_pessoas,"r")
  texto = arq.readlines #lendo todas as linhas do arquivo e jogando para um vetor.
  i = 0
  while (i < texto.length) #le até a ultima linha, no caso, ultima posição do vetor.
    linha = texto[i].split(';') #separa a linha por ; e atribui a outro vetor
    codigo = linha[0].to_i
    nome = linha[1].delete("\n")
    map_pessoas[codigo] = Pessoa.new(codigo,nome) #insere a pessoa na hash de pessoas.
    i += 1
  end
  arq.close
  return map_pessoas
end

#função para ler generos 
def read_generos(arq_generos) #possui o mesmo funcionamento que a função read_pessoas.
  map_generos = {}
  arq = File.new(arq_generos,"r")
  texto = arq.readlines 
  i = 0
  while (i < texto.length)
    linha = texto[i].split(';')
    sigla = linha[0]
    nome = linha[1].delete("\n")
    map_generos[sigla] = nome
    i += 1
  end
  arq.close
  return map_generos 
end


def read_emprestimos(arq_emprestimos, map_midias) #possui o mesmo funcionamento que a função read_pessoas.
  lista_emprestimos = []
  arq = File.new(arq_emprestimos,"r")
  texto = arq.readlines
  i = 0
  while (i < texto.length)
    linha = texto[i].split(';')
    codigo = linha[0].to_i
    nome = linha[1]
    inicio = linha[2]
    fim = linha[3].delete("\n")
    
    emprestimo = Emprestimo.new(codigo,nome,inicio,fim)
    lista_emprestimos = lista_emprestimos << emprestimo
    i += 1
  end
  arq.close
end


#função para ler midias
def read_midias(arq_midias, map_pessoas, map_generos)
  map_midias = {}
  arq = File.new(arq_midias,"r")
  texto = arq.readlines
  i = 0
  lista_autores = []
  while (i < texto.length)
    linha = texto[i].split(';')
    codigo = linha[0].to_i
    nome = linha[1]
    tipo = linha[2]
    diretor = linha[3]
    a_u_tores = linha[4]
    tamanho = linha[5]
    genero = map_generos[linha[6]]
    serie = linha[7]
    temporada = linha[8]
    possui = linha[9]
    consumiu = linha[10]
    deseja = linha[11]
    preco = linha[12].delete("\n").to_f
    
    if tipo == 'L' #caso a midia for do tipo Livro
      tipo = 'Livro'
      livro = Livro.new(possui, consumiu, deseja, nome, codigo, tamanho, preco, genero, tipo)
      lista_autores = a_u_tores.split(',') #caso possua mais de um autor, dividirá por virgulas.
      for j in 0...lista_autores.length #atribui cada autor para uma lista de autores do livro e adiciona a midia na respectiva pessoa.
        pessoa = map_pessoas[lista_autores[j].to_i]
        livro.add_autor(pessoa.nome)
        pessoa.add_midia(livro.nome)
      end
      
      map_midias[codigo] = livro #adiciona a midia criada na map de midias.
      
    end
  
    if tipo == 'F' #mesmo funcionamento que o tipo Livro.
      tipo = 'Filme'
      filme = Filme.new(possui, consumiu, deseja, nome, codigo, tamanho, preco, genero, tipo, diretor)
      lista_autores = a_u_tores.split(',')
      for j in 0...lista_autores.length
        pessoa = map_pessoas[lista_autores[j].to_i]
        filme.add_ator(pessoa.nome)
        pessoa.add_midia(filme.nome)
      end
      
      map_midias[codigo] = filme
    end  
    
    if tipo == 'S' #mesmo funcionamento que o tipo Livro.
      tipo = 'Serie'
      serie = Serie.new(possui, consumiu, deseja, nome, codigo, tamanho, preco, genero, tipo, temporada, serie)
      lista_autores = a_u_tores.split(',')
      for j in 0...lista_autores.length
        pessoa = map_pessoas[lista_autores[j].to_i]
        serie.add_ator(pessoa.nome)
        pessoa.add_midia(serie.nome)
      end
      
      map_midias[codigo] = serie 
    end
    i += 1
  end
  arq.close
  return map_midias
end
