#! /usr/bin/env lua

os.setlocale("pt_BR.UTF-8")

require "Func.aux"

alunos_f = io.open("alunos.csv", "r")
discp_f = io.open("disciplinas.csv", "r")
cursos_f = io.open("cursos.csv", "r")
notas_f = io.open("notas.csv", "r")
avaliac_f = io.open("avaliacoes.csv", "r")

alu_toTab, discp_toTab, cursos_toTab, avaliac_toTab, notas_toTab  = aux.alunocsv_tab, aux.discpcsv_tab, aux.cursoscsv_tab, aux.avaliaccsv_tab, aux.notascsv_tab
alunos_tab, discp_tab, cursos_tab, notas_tab, avaliac_tab, notas_avaliac = {}, {}, {}, {}, {}, {}

alunos_tab = alu_toTab(alunos_f); alunos_f:close()
discp_toTab(discp_f, discp_tab); discp_f:close()
cursos_toTab(cursos_f, cursos_tab); cursos_f:close()
avaliac_tab = avaliac_toTab(avaliac_f); avaliac_f:close()
notas_tab, notas_avaliac = notas_toTab(notas_f); notas_f:close()

pautafinal, estatisAV = aux.pautafinal, aux.estatisAvali

pautafinal_tab = pautafinal(discp_tab, alunos_tab, notas_tab, avaliac_tab)
aux.printPauta(pautafinal_tab)

estatis_pauta = estatisAV(notas_avaliac, discp_tab, avaliac_tab)
aux.printEstatis(estatis_pauta)
