-- Funções privadas do módulo
local function datasort(tab1, tab2)
    return tab1.time < tab2.time
end

local function nomesort(tab1, tab2)
    --a tabela a ser ordenada guarda o nome em [2]
    return tab1[2] < tab2[2]
end

local function codigosort(tab1, tab2)
    return tab1.codigo < tab2.codigo
end

local function round2(float)
    return math.floor(float*100 + 0.5)/100
end

local function estatistica(notas_avaliac, avaliacoes, disciplina, pauta)
    -- Avaliacoes é a tabela de avaliacoes, já ordenada, para disciplina
    for i = 1, #avaliacoes-1 do
        --Tabela com info da estatistica da avaliação
        --Index: númerico para ser concatenada
        local avaliac_estat = {}
        local codigo = avaliacoes[i].codigo
        avaliac_estat[1] = disciplina
        avaliac_estat[2] = codigo
        avaliac_estat[3] = avaliacoes[i].nome
        avaliac_estat[4] = avaliacoes[i].data

        -- soma de todas as notas na avaliação
        local media = notas_avaliac[codigo][1]
        -- Número de pessoas ou de grupos que fizeram a avaliação
        local num = #notas_avaliac[codigo][2]

        media = media/num
        media = round2(media)
        formatmedia = string.format("%.2f",media)
        avaliac_estat[5] = formatmedia

        table.insert(pauta, avaliac_estat)
    end
end

local function medias(aluDiscp_tab, notas_tab, avaliDiscp_tab)
    local media_alunos = {}

    for matricula, aluno in pairs(aluDiscp_tab) do
        local mediaparcial = 0
        local mediafinal = 0
        local num = 0

        --Informações do aluno para o arquivo de saída
        local aluno_info = {}
        aluno_info[1] = matricula
        aluno_info[2] = aluno.nome

        -- Todas as notas do aluno em questão
        local notas_aluno_tab = notas_tab[matricula]

        -- pega as notas apenas das avaliações da discplina em questão
        for _, info_avaliac in ipairs(avaliDiscp_tab) do
            local avaliacao = info_avaliac.codigo
            local peso = info_avaliac.peso
            local tipo = info_avaliac.tipo
            local nota = 0

            -- Nem todos os alunos fizeram final
            if (notas_aluno_tab[avaliacao] and tipo ~= "F") then
                nota = notas_aluno_tab[avaliacao]
                num = num + 1*peso

                -- avaliação já está ordenada por data
                local formatnota = string.format("%.2f",nota)
                table.insert(aluno_info, formatnota)
            end

            mediaparcial = mediaparcial + nota*peso
        end

        mediaparcial = mediaparcial / num
        mediaparcial = round2(mediaparcial)
        local formatparcial = string.format("%.2f",mediaparcial)
        table.insert(aluno_info, formatparcial)

        -- Verifica se ficou de final
        if (mediaparcial < 7.0) then
            local provafinal = avaliDiscp_tab[#avaliDiscp_tab].codigo
            local notapf = notas_aluno_tab[provafinal]

            mediafinal = (mediaparcial + notapf)/2
            mediafinal = round2(mediafinal)

            local formatfinal = string.format("%.2f",mediafinal)
            local formatnotapf = string.format("%.2f",notapf)
            table.insert(aluno_info, formatnotapf)
            table.insert(aluno_info, formatfinal)
        else
            table.insert(aluno_info, "-")
            table.insert(aluno_info, formatparcial)
        end

        -- Insere a info de um aluno na tabela das medias
        table.insert(media_alunos, aluno_info)
    end

    table.sort(media_alunos, nomesort)
    return media_alunos
end

-- Funções do Módulo
aux = {}

function aux.alunocsv_tab(arquivo)
    local i = 1
    local tabela_arq = {}
    for linha in arquivo:lines() do
        if (i ~= 1) then
            local matricula, nome, disciplinas, tipo, curso =                      linha:match("^([^;]*);([^;]*);([^;]*);([^;]*);([^;]*)$")
            for discp in disciplinas:gmatch("(%w+)") do
                if (tabela_arq[discp]) then
                    tabela_arq[discp][matricula] = {}
                    tabela_arq[discp][matricula].nome = nome
                    tabela_arq[discp][matricula].tipo = tipo
                    tabela_arq[discp][matricula].curso = curso
                else
                    tabela_arq[discp] = {}
                    tabela_arq[discp][matricula] = {}
                    tabela_arq[discp][matricula].nome = nome
                    tabela_arq[discp][matricula].tipo = tipo
                    tabela_arq[discp][matricula].curso = curso
                end
            end
        end
        i = i + 1
    end
    return tabela_arq
end

function aux.discpcsv_tab(arquivo, tabela_arq)
    local i = 1
    for linha in arquivo:lines() do
        tabela_arq[i] = {}
        tabela_arq[i].codigo, tabela_arq[i].nome = linha:match("^([^;]*);([^;]*)$")
        i = i + 1
    end
    table.remove(tabela_arq, 1)

    -- Disciplinas ordenadas por código
    table.sort(tabela_arq, codigosort)
end

function aux.cursoscsv_tab(arquivo, tabela_arq)
    local i = 1
    for linha in arquivo:lines() do
        tabela_arq[i] = {}
        tabela_arq[i].codigo, tabela_arq[i].nome = linha:match("^([^;]*);([^;]*)$")
        i = i + 1
    end
    table.remove(tabela_arq, 1)
end

function aux.avaliaccsv_tab(arquivo)
    local i = 1
    local tabela_arq = {}
    for linha in arquivo:lines() do
        if (i ~= 1) then
            local disciplina, codigo, nome, peso, tipo, data, tamgrupo  = linha:match("^([^;]*);([^;]*);([^;]*);([^;]*);([^;]*);([^;]*);?([^;]*)$")

            -- Pega os.time das datas
            local tabdata = {}
            tabdata.day, tabdata.month , tabdata.year = data:match("(%d+)/(%d+)/(%d+)")
            local datatime = os.time(tabdata)

            if (tabela_arq[disciplina]) then
                local avaliac = {}
                avaliac.codigo = codigo
                avaliac.nome = nome
                avaliac.peso = peso
                avaliac.tipo = tipo
                avaliac.data = data
                avaliac.tamgrupo = tamgrupo
                avaliac.time = datatime
                table.insert(tabela_arq[disciplina], avaliac)
            else
                tabela_arq[disciplina] = {}
                local avaliac = {}
                avaliac.codigo = codigo
                avaliac.nome = nome
                avaliac.peso = peso
                avaliac.tipo = tipo
                avaliac.data = data
                avaliac.tamgrupo = tamgrupo
                avaliac.time = datatime
                table.insert(tabela_arq[disciplina], avaliac)
            end
        end
        i = i + 1
    end

    --Ordena a tabela de avaliações para cada disciplina, por data
    for discp,_ in pairs(tabela_arq) do
        table.sort(tabela_arq[discp], datasort)
    end

    return tabela_arq
end

function aux.notascsv_tab(arquivo)
    local i = 1
    -- Tabela de notas com matricula como index
    local tabela_arq = {}
    -- Tabela de notas com Código da avaliação como index
    -- Não contém matricula do aluno
    local tabela_arq2 = {}

    for linha in arquivo:lines() do
        -- Quantos alunos fizeram a avaliação
        local count = 0
        -- Soma das notas de uma avaliação
        local soma = 0

        if (i ~= 1) then
            local avalicao, matriculas, nota = linha:match("^([^;]*);([^;]*);([^;]*)$")

            -- Criação da primeira tabela, e atualização de count
            for mat in matriculas:gmatch("(%w+)") do
                count = count + 1

                if (tabela_arq[mat]) then
                    tabela_arq[mat][avalicao] = nota
                else
                    tabela_arq[mat] = {}
                    tabela_arq[mat][avalicao] = nota
                end
            end

            -- Criação da segunda tabela_arq
            if (tabela_arq2[avalicao]) then
                soma = tabela_arq2[avalicao][1] + nota
                tabela_arq2[avalicao][1] = soma
                table.insert(tabela_arq2[avalicao][2], count)
            else
                tabela_arq2[avalicao] = {}
                tabela_arq2[avalicao][2] = {}

                --Primeira vez na avaliação, soma = nota em questão
                tabela_arq2[avalicao][1] = nota
                table.insert(tabela_arq2[avalicao][2], count)
            end
        end
        i = i + 1
    end
    return tabela_arq, tabela_arq2
end

function aux.pautafinal(discp_tab, alunos_tab, notas_tab, avaliac_tab)
    local pautafinal_tab = {}
    for i, disciplina in ipairs(discp_tab) do

        -- código da disciplina iterada
        local discp_codigo = disciplina.codigo

        -- tabela de tabelas das avaliacoes da disciplina
        --index: código da avaliaçao, retorna tabela da avaliaçao
        local avaliac_discp_tab = avaliac_tab[discp_codigo]

        -- tabela de tabelas para alunos na disciplina
        local alunos_discp_tab = alunos_tab[discp_codigo]

        local media_discpl = medias(alunos_discp_tab, notas_tab, avaliac_discp_tab)

        -- Tem que ser depois, adicionar a legenda do arquivo
        local colunas = "Matrícula;Aluno;"
        for i = 1,#avaliac_discp_tab-1 do
            codigo = avaliac_discp_tab[i].codigo
            colunas = colunas..codigo..";"
        end

        colunas = colunas.."Média Parcial;Prova Final;Média Final"
        table.insert(media_discpl, 1, colunas)

        -- Insere a tabela da pauta de uma disciplina na tabela das pautas
        -- Index: código da discplina
        pautafinal_tab[discp_codigo] = media_discpl
    end

    return pautafinal_tab
end

function aux.printPauta(pauta_tab)
    for discpl, discpl_info in pairs(pauta_tab) do
        --Nome da pauta
        local arquivo = "1-pauta-"..discpl..".csv"
        local pauta = io.open(arquivo, "w+")

        for indice, info in ipairs(discpl_info) do

            -- O primeiro indíce é a string da legenda do arquivo
            if (indice ~= 1) then
                linha = table.concat(info, ";").."\n"
                pauta:write(linha)
            else
                pauta:write(info.."\n")
            end
        end

        pauta:close()
    end
end

function aux.estatisAvali(notas_avaliac, discp_tab, avaliac_tab)
    local pauta_estatis = {}

    for _, disciplina in ipairs(discp_tab) do
        local

        -- Código da disciplina iterada, já está ordenada
        discp_codigo = disciplina.codigo

        --Avaliações da disciplina em questão, já ordenadas
        avaliac_daDiscpl = avaliac_tab[discp_codigo]

        estatistica(notas_avaliac, avaliac_daDiscpl, discp_codigo, pauta_estatis)
    end

    return pauta_estatis
end

function aux.printEstatis(pauta_estatis)
    local pauta = io.open("3-avaliacoes.csv", "w+")

    --Escreve a legenda do arquivo
    string = "Disciplina;Código;Avaliação;Data;Média"
    pauta:write(string.."\n")

    for _, info in ipairs(pauta_estatis) do
        linha = table.concat(info, ";").."\n"
        pauta:write(linha)
    end

    pauta:close()
end

return aux
