#!/usr/bin/perl

use strict;
use warnings;

######## Função que retornará o índice do nome de um determinado relatório na lista de argumentos, dado seu parâmetro especial (-c, -a, -v, -f, -p)
sub Extract_Label
{
	my @args = @ARGV;
	my $i = 0;
	foreach (@args)
	{
		if($_ eq $_[0])
		{
			last;
		}
		$i++;
	}

	return $i;
}

sub LeituraDeMapas
{
	my $arquivo = $ARGV[$_[0]+1];
	my %Mapa;

	open(my $buffer, '<', $arquivo) or die "Não foi possível abrir o arquivo $arquivo!";
	my $line = <$buffer>;
	while ($line = <$buffer>)
	{
		chomp $line;
		my @fields = split ";",$line;
		$Mapa{$fields[0]} = \@fields;
	}

	return %Mapa;	
}

sub LeituraDeListas
{
	my $arquivo = $ARGV[$_[0]+1];
	my @Lista;
	my $i = 0;
	my $j = 0;
	open(my $buffer, '<', $arquivo) or die "Não foi possível abrir o arquivo $arquivo!";
	my $line = <$buffer>;
	while ($line = <$buffer>)
	{
		chomp $line;
		$j = 0;
		my @fields = split ";",$line;
		foreach(@fields)
		{
			$Lista[$i][$j] = $_;
			$j++;
		}
		$i++;
	}

	return @Lista;	
}

sub Arruma_Precos
{
	my %MapaDeProdutos = %{$_[0]};

	foreach my $key (keys %MapaDeProdutos)
	{
		$MapaDeProdutos{$key}[4] =~ tr/,/./;
	}
}

sub A_pagar
{
	my $arquivo = "1-apagar2.csv";
	my $custo = 0;
	my @ListaDeCompras = @{$_[0]};
	my %MapaDeFornecedores = %{$_[1]};
	my %MapaDeProdutos = %{$_[2]};
	my @A_Pagar;
	my $i = 0;

	open(my $buffer, '>', $arquivo) or die "Não foi possível abrir o arquivo $arquivo!";
	print $buffer "Fornecedor;CNPJ;Pessoa de contato ;Telefone;Total a pagar\n";

	foreach my $key (keys %MapaDeFornecedores)
	{
		foreach my $row (0..@ListaDeCompras-1)
		{
			if($ListaDeCompras[$row][1] == $key)
			{
				$custo = $custo + ($MapaDeProdutos{$ListaDeCompras[$row][3]}[4]*$ListaDeCompras[$row][4]);
			}
		}
		
		$A_Pagar[$i][0] = $MapaDeFornecedores{$key}[1];
		$A_Pagar[$i][1] = $MapaDeFornecedores{$key}[4];
		$A_Pagar[$i][2] = $MapaDeFornecedores{$key}[5];
		$A_Pagar[$i][3] = $MapaDeFornecedores{$key}[3];
		
		my $custo_r = sprintf("%.02f", $custo);
		$custo_r =~ tr/./,/;
		$A_Pagar[$i][4] = $custo_r;
		$i++;
		$custo = 0;
	}

	my @sorted_A_Pagar = sort { $a->[0] cmp $b->[0] } @A_Pagar;	
	
	foreach my $row (0..@sorted_A_Pagar-1)
	{
		print $buffer "$sorted_A_Pagar[$row][0];$sorted_A_Pagar[$row][1];$sorted_A_Pagar[$row][2];$sorted_A_Pagar[$row][3];R\$ $sorted_A_Pagar[$row][4]\n";
	}	
}

sub A_Receber
{
	my $arquivo = "2-areceber2.csv";
	my $receita = 0;
	my @ListaDeVendas = @{$_[0]};
	my %MapaDeClientes = %{$_[1]};
	my %MapaDeProdutos = %{$_[2]};
	my @A_Receber;
	my $i = 0;

	open(my $buffer, '>', $arquivo) or die "Não foi possível abrir o arquivo $arquivo!";
	print $buffer "Cliente;Tipo;CPF/CNPJ;Telefone;Data de cadastro;Total a pagar\n";

	foreach my $key (keys %MapaDeClientes)
	{
		foreach my $row (0..@ListaDeVendas-1)
		{
			if($ListaDeVendas[$row][0] ne "")
			{
				if($ListaDeVendas[$row][0] == $key)
				{
					my $preco = $MapaDeProdutos{$ListaDeVendas[$row][2]}[4]; 
					my $porcentagem = $MapaDeProdutos{$ListaDeVendas[$row][2]}[5];
					my $quantidade = $ListaDeVendas[$row][3];
					$receita = $receita + ($preco + $preco*($porcentagem)/100)*$quantidade;
				}
			}
		}
		
		$A_Receber[$i][0] = $MapaDeClientes{$key}[1];
		$A_Receber[$i][1] = $MapaDeClientes{$key}[5];
		$A_Receber[$i][2] = $MapaDeClientes{$key}[6];
		$A_Receber[$i][3] = $MapaDeClientes{$key}[3];
		$A_Receber[$i][4] = $MapaDeClientes{$key}[4];
		
		my $receita_r = sprintf("%.02f", $receita);
		$receita_r =~ tr/./,/;
		$A_Receber[$i][5] = $receita_r;
		$i++;
		$receita = 0;
	}

	my @sorted_A_Receber = sort { $a->[0] cmp $b->[0] } @A_Receber;	
	
	foreach my $row (0..@sorted_A_Receber-1)
	{
		print $buffer "$sorted_A_Receber[$row][0];$sorted_A_Receber[$row][1];$sorted_A_Receber[$row][2];$sorted_A_Receber[$row][3];$sorted_A_Receber[$row][4];R\$ $sorted_A_Receber[$row][5]\n";
	}	
}

######## Gera mapa de produtos, com as chaves sendo os códigos dos produtos! ########
######## Foi usado um REGEXP nos preços dos produtos para trocar o caracter ',' por '.' ########
my $label = &Extract_Label("-p");
my %MapaDeProdutos = &LeituraDeMapas($label);
&Arruma_Precos(\%MapaDeProdutos);

######## Gera mapa de clientes, com as chaves sendo os códigos dos clientes! ########
$label = &Extract_Label("-c");
my %MapaDeClientes = &LeituraDeMapas($label);

######## Gera mapa de fornecedores, com as chaves sendo os códigos dos fornecedores! ########
$label = &Extract_Label("-f");
my %MapaDeFornecedores = &LeituraDeMapas($label);

######## Gera uma lista (array de arrays ou matriz) de vendas ########
$label = &Extract_Label("-v");
my @ListaDeVendas = &LeituraDeListas($label);

######## Gera uma lista (array de arrays ou matriz) de compras ########
$label = &Extract_Label("-a");
my @ListaDeCompras = &LeituraDeListas($label);

######## Gera relatório "A Pagar" para fornecedores ########
&A_pagar(\@ListaDeCompras, \%MapaDeFornecedores, \%MapaDeProdutos);

######## Gera relatório "A Receber" de clientes ########
&A_Receber(\@ListaDeVendas, \%MapaDeClientes, \%MapaDeProdutos);
