package oak.dominio

import java.text.NumberFormat
import java.text.ParseException
import java.text.SimpleDateFormat

class Main {
	private static def clientes = [], fornecedores = [], produtos = [], compras = [], vendas = []
	private static def apagar = new File("1-apagar.csv")
	private static def areceber = new File("2-areceber.csv")
	/*private static def vendasprod = new File("3-vendasprod.csv")
	private static def vendaspgto = new File("4-vendaspgto.csv")
	private static def estoque = new File("5-estoque.csv")*/
	private static def nf = NumberFormat.getCurrencyInstance(new Locale("pt","BR")), df = new SimpleDateFormat("dd/MM/yyyy")
	
	private static void adicionarCliente(list, f){
		try{
			def s = new Scanner(f).useDelimiter("\\s*;\\s*|\\s*\n\\s*")
			int cod, insc = 0
			String n, end, tel, cpf="0", cnpj="0", tipo, data
			Date date
			s.nextLine()
			while(s.hasNext()){
				cod=s.nextInt()
				n=s.next()
				end=s.next()
				tel=s.next()
				data=s.next()
				date=df.parse(data)
				tipo=s.next()
				if(tipo=="J"){
					cnpj=s.next()
					insc=s.nextInt()
					list<<(new ClienteJuridico(cod,n,end,tel,cnpj,insc,date))
				}
				else {
					cpf=s.next()
					list<<(new ClienteFisico(cod,n,end,tel,cpf,date))
				}
			}
			s.close()
		}
		catch(IOException e){println "Erro de I/O."}
	}
	
	private static void adicionarFornecedor(list, f){
		try{
			def s = new Scanner(f).useDelimiter("\\s*;\\s*|\\s*\n\\s*")
			int cod
			String n,end,tel,cnpj,contato
			s.nextLine()
			while(s.hasNext()){
				cod=s.nextInt()
				n=s.next()
				end=s.next()
				tel=s.next()
				cnpj=s.next()
				contato=s.next()
				list<<(new Fornecedor(cod,n,end,tel,cnpj,contato))
			}
			s.close()
		}
		catch(IOException e){println "Erro de I/O."}
	}
	
	private static void adicionarProdutos(list, f){
		try{
			def s = new Scanner(f).useDelimiter("\\s*;\\s*|\\s*\n\\s*")
			int codProduto,estMin,estAtual,lucro
			String desc
			double custo
			s.nextLine()
			while(s.hasNext()){
				codProduto=s.nextInt()
				desc=s.next()
				estMin=s.nextInt()
				estAtual=s.nextInt()
				custo=s.nextDouble()
				lucro=s.nextInt()
				list<<(new Produto(codProduto,estMin,estAtual,lucro,desc,custo))
			}
			s.close()
		}
		catch(IOException e){println "Erro de I/O."}
	}
	
	private static void adicionarVendas(list, f){
		try{
			def s = new Scanner(f).useDelimiter("\\s*;\\s*|\\s*\n\\s*")
			int codCliente=0,codProduto=0,quant
			String meio,data
			Date date
			s.nextLine()
			while(s.hasNext()){
				if(s.hasNextInt())
					codCliente=s.nextInt()
				data=s.next()
				codProduto=s.nextInt()
				quant=s.nextInt()
				meio=s.next()
				date=df.parse(data)
				if(meio=="F")
					list<<(new Vendas(clientes.find{it.codigoId==codCliente},produtos.find{it.codigo==codProduto},date,quant,meio))
				else list<<(new Vendas(null,produtos.find{it.codigo==codProduto},date,quant,meio))
			}
			s.close()
		}
		catch(IOException e){println "Erro de I/O."}
	}
	
	private static void adicionarCompras(list, f){
		try{
			def s = new Scanner(f).useDelimiter("\\s*;\\s*|\\s*\n\\s*")
			int codFornecedor=0,codProduto=0,notaFiscal=0,quant
			String data
			Date date
			s.nextLine()
			while(s.hasNext()){
				notaFiscal=s.nextInt()
				codFornecedor=s.nextInt()
				data=s.next()
				codProduto=s.nextInt()
				quant=s.nextInt()
				date=df.parse(data)
				list<<(new Compras(notaFiscal,quant,fornecedores.find{it.codigoId==codFornecedor},produtos.find{it.codigo==codProduto},date))
			}
			s.close()
		}
		catch(IOException e){println "Erro de I/O."}
	}
	
	private static void adicionarAPagar(listf, listc, fw){
		try{
			def writer = new FileWriter(fw)
			writer.write("Fornecedor;CNPJ;Pessoa de contato ;Telefone;Total a pagar\n")
			for(f in listf){
				double v=0
				listc.each{if(f<=>it.f==0) v=v+it.valorPago}
				writer.write(f.nome+";"+f.cnpj+";"+f.pessoaContato+";"+f.telefone+";"+nf.format(v)+"\n")
			}
			writer.flush()
		    writer.close()
		}
		catch(IOException e){println "Erro de I/O."}
	}
	
	private static void adicionarAReceber(listc, listv, fw){
		try{
			def writer = new FileWriter(fw)
			writer.write("Cliente;Tipo;CPF/CNPJ;Telefone;Data de cadastro;Total a pagar\n")
			for(c in listc){
				double v=0
				listv.each{if(it.c!=null&&c<=>it.c==0) v=v+it.valorDaVenda}
				if(c instanceof ClienteFisico)
					writer.write(c.nome+";F;"+((ClienteFisico)c).cpf+";"+c.telefone+";"+df.format(c.dataCadastro)+";"+nf.format(v)+"\n")
				else writer.write(c.nome+";J;"+((ClienteJuridico)c).cnpj+";"+c.telefone+";"+df.format(c.dataCadastro)+";"+nf.format(v)+"\n")
			}
			writer.flush()
		    writer.close()
		}
		catch(IOException e){println "Erro de I/O."}
	}
	
	static void main(def args) {
		def c,f,p,a,v
		for(int i in 0..(args.length-1)){
			switch(args[i]){
				case "-c":
					c=new File(args[++i])
					break
				case "-f":
					f=new File(args[++i])
					break
				case "-p":
					p=new File(args[++i])
					break
				case "-a":
					a=new File(args[++i])
					break
				case "-v":
					v=new File(args[++i])
					break
			}
		}
		
		adicionarCliente(clientes,c)
		adicionarFornecedor(fornecedores,f)
		adicionarProdutos(produtos,p)
		adicionarCompras(compras,a)
		adicionarVendas(vendas,v)
		
		fornecedores.sort()
		compras.sort()
		adicionarAPagar(fornecedores,compras,apagar)
			
		clientes.sort()
		vendas.sort()
		adicionarAReceber(clientes,vendas,areceber)
		
		println "Programa Terminado!"
	}

}
