#import <stdio.h>
#import <stdlib.h>
#import <objc/Object.h>
#import <Foundation/Foundation.h>
//*************************************CLASSE  ITEM****************************************
//-------------------------------------   Item.h   ----------------------------------------
@interface Item: NSObject{
	@private
	NSInteger cod;
	NSString* nome;
	double preco;
}
	-(id)init:(NSInteger)codigo:(NSString *)nomeProduto:(float)valor;
	-(double)getPreco;
	-(NSInteger)getCodigo;
	-(NSString*)getNome;
	-(void)imprime;
	-(bool)equals:(Item*)item;
@end
//-------------------------------------   Item.m   ----------------------------------------
@implementation Item{
	@private
	NSInteger cod;
	NSString* nome;
	double preco;
}
	-(id)init:(NSInteger)codigo:(NSString *)nomeProduto:(float)valor{
		self = [super init];
		if(self){
			nome = nomeProduto;
			preco = valor;
			cod = codigo;
		}
		return self;
	}
	-(double)getPreco{
		return preco;
	}
	-(NSInteger)getCodigo{
		return cod;
	}
	-(NSString*)getNome{
		return nome;
	}
	-(void)imprime{
		printf("%d\tR$%.2f\t%s\n", cod, preco, [nome UTF8String]);
	}
	-(bool)equals:(Item*)item{
		if(cod == [item getCodigo]){
			return true;
		}
		return false;
	}
@end
//*************************************CLASSE  ENTREGADOR**********************************
//-------------------------------------   Entregador.h   ----------------------------------
@interface Entregador: NSObject{
	NSString* nome;
	NSString* placa;
	int codigo;
}
	-(id)init:(NSString*)setnome:(NSString*)setplaca:(int)cod;
	-(NSString*)getNome;
	-(int)getCodigo;
	-(void)imprime;
@end
//-------------------------------------   Entregador.m   ----------------------------------
@implementation Entregador{
	NSString* nome;
	NSString* placa;
	int codigo;
}
	-(id)init:(NSString*)setnome:(NSString*)setplaca:(int)cod{
		self = [super init];
		if(self){
			codigo = cod;
			nome = setnome;
			placa = setplaca;
		}
		return self;
	}
	-(NSString*)getNome{
		return nome;
	}
	-(int)getCodigo{
		return codigo;
	}
	-(void)imprime{
		printf("%s %s\n", [nome UTF8String], [placa UTF8String]);
	}
@end
//*************************************CLASSE  CLIENTE*************************************
//-------------------------------------   Cliente.h   -------------------------------------
@interface Cliente: NSObject{
	NSString* nome;
	NSString* endereco;
	NSString* telefone;
	NSString* pontoRef;
}
	-(id)init:(NSString*)setnome:(NSString*)end:(NSString*)tel:(NSString*)ref;
	-(void)setNome:(NSString*)setnome;
	-(void)setEndereco:(NSString*)end;
	-(void)setTelefone:(NSString*)tel;
	-(void)setReferencia:(NSString*)ref;
	-(NSString*)getNome;
	-(NSString*)getEndereco;
	-(NSString*)getTelefone;
	-(NSString*)getReferencia;
	-(void)imprime;
@end
//-------------------------------------   Cliente.m   -------------------------------------
@implementation Cliente{
	NSString* nome;
	NSString* endereco;
	NSString* telefone;
	NSString* pontoRef;
}
	-(id)init:(NSString*)setnome:(NSString*)end:(NSString*)tel:(NSString*)ref{
		self = [super init];
		if(self){
			telefone = tel;
			nome = setnome;
			endereco = end;
			pontoRef = ref;
		}
		return self;
	}
	-(void)setNome:(NSString*)setnome{
		nome = setnome;
	}
	-(void)setEndereco:(NSString*)end{
		endereco = end;
	}
	-(void)setTelefone:(NSString*)tel{
		telefone = tel;
	}
	-(void)setReferencia:(NSString*)ref{
		pontoRef = ref;
	}
	-(NSString*)getNome{
		return nome;
	}
	-(NSString*)getEndereco{
		return endereco;
	}
	-(NSString*)getTelefone{
		return telefone;
	}
	-(NSString*)getReferencia{
		return pontoRef;
	}
	-(void)imprime{
		printf("Nome:%s\nEndereço:%s\nTelefone:%s\nReferencia:%s\n", [nome UTF8String], [endereco UTF8String], telefone, [pontoRef UTF8String]);
	}
@end
//*************************************CLASSE  ITEMPEDIDO**********************************
//-------------------------------------   ItemPedido.h   ----------------------------------
@interface ItemPedido: NSObject{
	NSInteger quantidade;
	Item* item;
	bool procura;
	double valor;
}
	-(id)init:(Item*)i:(NSInteger)qtd;
	-(double)getValor;
	-(Item*)getItem;
	-(NSInteger)getQuantidade;
	-(void)setQuantidade:(NSInteger)qtd;
@end
//-------------------------------------   ItemPedido.m   ----------------------------------
@implementation ItemPedido{
	NSInteger quantidade;
	Item* item;
	bool procura;
	double valor;
}
	-(id)init:(Item*)i:(NSInteger)qtd{
		self = [super init];
		if(self){
			item = i;
			quantidade = qtd;
			if(quantidade >= 5){
				procura = true;
			}else{
				procura = false;
			}
			valor = [i getPreco]*qtd;
		}
		return self;
	}
	-(double)getValor{
		return valor;
	}
	-(Item*)getItem{
		return item;
	}
	-(NSInteger)getQuantidade{
		return quantidade;
	}
	-(void)addQuantidade:(NSInteger)qtd{
		quantidade = quantidade + qtd;
		valor = [item getPreco]*quantidade;
		if(quantidade >= 5){
			procura = true;
		}
	}
@end
//*************************************CLASSE  PEDIDO**************************************
//-------------------------------------   Pedido.h   --------------------------------------
@interface Pedido: NSObject{
	Cliente* cliente;
	NSMutableArray* itensPedidos;
	Entregador* entregador;
	double total;
}
	-(id)init:(Cliente*)clt;
	-(void)addItem:(NSInteger)qtd:(Item*)item;
	-(void)setEntregador:(Entregador*)ent;
	-(Entregador*)getEntregador;
	-(double)getTotal;
	-(ItemPedido*)getItemPedido:(Item*)item;
@end
//-------------------------------------   Pedido.m   --------------------------------------
@implementation Pedido{
	Cliente* cliente;
	NSMutableArray* itensPedidos;
	Entregador* entregador;
	double total;
}
	-(id)init:(Cliente*)clt{
		self = [super init];
		if(self){
			cliente = clt;
			[[NSMutableArray alloc] init];
			total = 0;
		}
		return self;
	}
	-(void)addItem:(NSInteger)qtd:(Item*)item{
		ItemPedido* aux = [self getItemPedido:item];
		if(aux != nil){
			[aux addQuantidade: qtd];
		}else{
			aux = [[ItemPedido alloc] init:item:qtd];
			[itensPedidos addObject:aux];
		}
		total = total + [item getPreco]*qtd;
	}
	-(void)setEntregador:(Entregador*)ent{
		entregador = ent;
	}
	-(Entregador*)getEntregador{
		return entregador;
	}
	-(double)getTotal{
		return total;
	}
	-(ItemPedido*)getItemPedido:(Item*)item{
		for(ItemPedido* ip in itensPedidos){
			if([[ip getItem] equals:item]){
				return ip;
			}
		}
		return nil;
	}
@end
//*************************************CLASSE  ITEMRELATORIO***********************************
//-------------------------------------   ItemRelatorio.h   -----------------------------------
@interface ItemRelatorio: NSObject{
	Item* item;
	NSInteger quantidade;
	bool pico;
}
	-(id)init:(Item*)it:(NSInteger)qtd:(bool)p;
	-(Item*)getItem;
	-(NSInteger)getQuantidade;
	-(void)setQuantidade:(NSInteger)qtd;
	-(bool)isPico;
	-(void)setPico:(bool)p;
@end
//-------------------------------------   ItemRelatorio.m   -------------------------------
@implementation ItemRelatorio{
	Item* item;
	NSInteger quantidade;
	bool pico;
}
	-(id)init:(Item*)it:(NSInteger)qtd:(bool)p{
		self = [super init];
		if(self){
			item = it;
			quantidade = qtd;
			pico = p;
		}
		return self;
	}
	-(Item*)getItem{
		return item;
	}
	-(NSInteger)getQuantidade{
		return quantidade;
	}
	-(void)set:(NSInteger)qtd{
		quantidade = qtd;
	}
	-(bool)isPico{
		return pico;
	}
	-(void)setPico:(bool)p{
		pico = p;
	}
@end
//*************************************CLASSE  CONTROLADOR*********************************
//-------------------------------------   Controlador.h   ---------------------------------

@interface Controlador: NSObject{
	NSMutableArray* clientes;
	NSMutableArray* cardapio;
	NSMutableArray* entregadores;
	NSMutableArray* pedidos;
	NSMutableArray* relatorio;
}
	-(id)init:(NSString*)itens:(NSString*)entregador;
	-(void)loadCardapio:(NSString*)itens;
	-(void)loadEntregadores:(NSString*)entregador;
	-(Cliente*)getCliente:(NSString*)tel;
	-(bool)itemExiste:(NSInteger)codigo;
	-(Item*)getItem:(NSInteger)codigo;
	-(void)mostrarCardapio;
	-(Entregador*)alocarEntregador;
	-(void)addPedido:(Pedido*)pedido;
	-(void)gerarRelatorio;
	-(void)addItemRelatorio:(ItemPedido*)ip;
	-(void)escreverRelatorio;
@end
//-------------------------------------   Controlador.m   ---------------------------------
@implementation Controlador{
	NSMutableArray* clientes;
	NSMutableArray* cardapio;
	NSMutableArray* entregadores;
	NSMutableArray* pedidos;
	NSMutableArray* relatorio;
}
	-(id)init: (NSString*)itens: (NSString*)entregador{
		self = [super init];
		if(self){
			clientes = [[NSMutableArray alloc] init];
			cardapio = [[NSMutableArray alloc] init];
			entregadores = [[NSMutableArray alloc] init];
			pedidos = [[NSMutableArray alloc] init];
			relatorio = [[NSMutableArray alloc] init];
			[self loadCardapio: itens];
			[self loadEntregadores: entregador];
		}
		return self;
	}
	-(void)loadCardapio: (NSString*)itens{
		NSString* linhas = [NSString stringWithContentsOfFile: itens];
		if(linhas != nil){
			NSMutableArray* linha = [linhas componentsSeparatedByString: @"\n"];
			for(NSString* elementos in linha){
				NSMutableArray* elemento = [elementos componentsSeparatedByString: @";"];
				if([elemento count] == 3){
					NSInteger cod = [[elemento objectAtIndex: 0] integerValue];
					NSString* nome = [elemento objectAtIndex: 1];
					float valor = [[elemento objectAtIndex: 2] floatValue];
					Item* itemCardapio = [[Item alloc] init: cod: nome: valor];
					[cardapio addObject: itemCardapio];
				}
			}
		}else{
			printf("Não foi possível processar o arquivo especificado: %s\n", [itens UTF8String]);
			exit(0);
		}
	}
	-(void)loadEntregadores: (NSString*)entregador{
		int cod = 0;
		NSString* linhas = [NSString stringWithContentsOfFile: entregador];
		if(linhas != nil){
			NSMutableArray* linha = [linhas componentsSeparatedByString: @"\n"];
			for(NSString* elementos in linha){
				NSMutableArray* elemento = [elementos componentsSeparatedByString: @";"];
				if([elemento count] == 2){
					NSString* nome = [elemento objectAtIndex: 0];
					NSString* placa = [elemento objectAtIndex: 1];
					Entregador* ent = [[Entregador alloc] init: nome: placa: cod];
					[entregadores addObject: ent];
					cod++;
				}
			}
		}else{
			printf("Não foi possível processar o arquivo especificado: %s\n", [entregador UTF8String]);
			exit(0);
		}
	}
	-(Cliente*)getCliente:(NSString*)tel{
		//procura Cliente
		NSInteger index = 0;
		bool existe = false;
		if(![clientes count]){
			for(Cliente* cliente in clientes){
				NSLog(@"%s\n", [cliente getTelefone]);
				if([[cliente getTelefone] isEqualToString:tel]){
					NSLog(@"Comparou certo!");
					existe = true;
				}
				index++;
			}
		}
		//Variaveis para fazer o equivalente ao scanf
		NSFileHandle* input;
		NSData* inputData;
		//Cadastro e Recadastro
		while(true){
			if(existe){
				system("clear");
				printf("Cliente cadastrado:%s\n[C]onfirma ou [R]ecadastra:\n", [[[clientes objectAtIndex: index] getNome] UTF8String]);
				while(true){
					input = [NSFileHandle fileHandleWithStandardInput];
					inputData = [NSData dataWithData:[input availableData]];
					NSString* inputString = [[NSString alloc] initWithData:inputData encoding:NSUTF8StringEncoding];
					inputString = [inputString stringByTrimmingCharactersInSet:[NSCharacterSet whitespaceAndNewlineCharacterSet]];
					if([inputString isEqualToString:@"c"] || [inputString isEqualToString:@"C"]){
						return [clientes objectAtIndex: index];
					}else{
						if([inputString isEqualToString:@"r"] || [inputString isEqualToString:@"R"]){
							system("clear");
							printf("Recadastrando cliente (telefone %s):\nNome:\n", [tel UTF8String]);
							break;
						}else{
							printf("Comando inválido\n[C]onfirma ou [R]ecadastra:\n");
						}
					}
				}
			}else{
				system("clear");
				printf("Cliente não cadastrado. Novo cadastro\nNome:\n");
			}
			input = [NSFileHandle fileHandleWithStandardInput];
			inputData = [NSData dataWithData:[input availableData]];
			NSString* nome = [[NSString alloc] initWithData:inputData encoding:NSUTF8StringEncoding];
			nome = [nome stringByTrimmingCharactersInSet:[NSCharacterSet whitespaceAndNewlineCharacterSet]];

			printf("Endereco: \n");
			input = [NSFileHandle fileHandleWithStandardInput];
			inputData = [NSData dataWithData:[input availableData]];
			NSString* endereco = [[NSString alloc] initWithData:inputData encoding:NSUTF8StringEncoding];
			endereco = [endereco stringByTrimmingCharactersInSet:[NSCharacterSet whitespaceAndNewlineCharacterSet]];

			printf("Ponto de referência: \n");
			input = [NSFileHandle fileHandleWithStandardInput];
			inputData = [NSData dataWithData:[input availableData]];
			NSString* ref = [[NSString alloc] initWithData:inputData encoding:NSUTF8StringEncoding];
			ref = [ref stringByTrimmingCharactersInSet:[NSCharacterSet whitespaceAndNewlineCharacterSet]];

			if(!existe){
				index = [clientes count];
				Cliente* clt = [[Cliente alloc] init: nome: endereco: tel: ref];
				[clientes addObject: clt];
				existe = true;
			}else{
				[[clientes objectAtIndex: index] setNome: nome];
				[[clientes objectAtIndex: index] setEndereco: endereco];
				[[clientes objectAtIndex: index] setTelefone: tel];
				[[clientes objectAtIndex: index] setReferencia: ref];
			}
		}
	}
	-(bool)itemExiste:(NSInteger)codigo{
		for(Item* i in cardapio){
			if([i getCodigo] == codigo){
				return true;
			}
		}
		return false;
	}
	-(Item*)getItem:(NSInteger)codigo{
		for(Item* i in cardapio){
			if([i getCodigo] == codigo){
				return i;
			}
		}
		return nil;
	}
	-(void)mostrarCardapio{
		for(Item* item in cardapio){
			[item imprime];
		}
	}
	-(Entregador*)alocarEntregador{
		NSInteger r = rand()%[entregadores count];
		return [entregadores objectAtIndex: r];
	}
	-(void)addPedido:(Pedido*)pedido{
		[pedidos addObject: pedido];
	}
	-(void)gerarRelatorio{
		[[NSFileManager defaultManager] createFileAtPath:@"Entregadores.csv" contents:nil attributes:nil];
		NSFileHandle* output = [NSFileHandle fileHandleForWritingAtPath: @"Entregadores.csv"];
		NSData* outData = [@"Relatório de Entregadores\n" dataUsingEncoding:NSUTF8StringEncoding];
		[output writeData: outData];
		NSInteger nEnt;
		double vTotal;
		for(Entregador* e in entregadores){
			nEnt = 0;
			vTotal = 0;
			NSString* linha;
			for(Pedido* p in pedidos){
				if([[e getNome] isEqualToString: [[p getEntregador] getNome]]){
					vTotal = vTotal + [p getTotal];
					nEnt++;
				}
			}
			linha = [NSString stringWithFormat:@"%s;%d;R$%.2f;R$%.2f\n", [[e getNome] UTF8String], nEnt, vTotal, (vTotal*0.05)];
			outData = [linha dataUsingEncoding:NSUTF8StringEncoding];
			[output writeData: outData];
		}
	}
@end
//*************************************CLASSE PRINCIPAL************************************
int main(int argc, char *argv[]){
	NSAutoreleasePool* pool = [[NSAutoreleasePool alloc] init];
	//Verifica números de parâmetros
	if(argc == 5){
		char* par1 = argv[1];
		char* par3 = argv[3];
		//Verifica se os parâmetros 1 e 3 são -c ou -e
		if(strcmp(par1, "-c") == 0 || strcmp(par1, "-e") == 0){
			if (strcmp(par3, "-c") == 0 || strcmp(par3, "-e") == 0){
				NSString* par2 = [[NSString alloc] initWithCString:argv[2] encoding:NSUTF8StringEncoding];
				NSString* par4 = [[NSString alloc] initWithCString:argv[4] encoding:NSUTF8StringEncoding];
				Controlador* control = [Controlador alloc];
				if(strcmp(par1, "-c") == 0){
					[control init: par2: par4];
				}else{
					[control init: par4: par2];
				}
				//------------------Corpo do Programa-----------------------
				NSFileHandle* input;
				NSData* inputData;
				NSString* inputString;
				system("clear");
				while(true){
					printf("Telefone (0 para sair):\n");
					input = [NSFileHandle fileHandleWithStandardInput];
					inputData = [NSData dataWithData:[input availableData]];
					inputString = [[NSString alloc] initWithData:inputData encoding:NSUTF8StringEncoding];
					inputString = [inputString stringByTrimmingCharactersInSet:[NSCharacterSet whitespaceAndNewlineCharacterSet]];
					NSString* tel = inputString;
					if([tel longLongValue] == 0){
						break;
					}else{
						Cliente* clt;
						clt = [control getCliente: tel];
						Pedido* pedido = [[Pedido alloc] init: clt];
						system("clear");
						while(true){
							printf("Adicionar item número (? para cardápio, 0 para finalizar):\n");
							input = [NSFileHandle fileHandleWithStandardInput];
							inputData = [NSData dataWithData:[input availableData]];
							inputString = [[NSString alloc] initWithData:inputData encoding:NSUTF8StringEncoding];
							inputString = [inputString stringByTrimmingCharactersInSet:[NSCharacterSet whitespaceAndNewlineCharacterSet]];

							if([inputString isEqualToString:@"?"]){
								system("clear");
								[control mostrarCardapio];
							}else{
								NSInteger codigo = [inputString integerValue];
								if(codigo == 0){
									break;
								}else{
									if([control itemExiste: codigo]){
										Item* it = [control getItem: codigo];
										printf("Adicionando %s ao pedido.Quantidade:\n", [[it getNome] UTF8String]);
										input = [NSFileHandle fileHandleWithStandardInput];
										inputData = [NSData dataWithData:[input availableData]];
										inputString = [[NSString alloc] initWithData:inputData encoding:NSUTF8StringEncoding];
										inputString = [inputString stringByTrimmingCharactersInSet:[NSCharacterSet whitespaceAndNewlineCharacterSet]];
										NSInteger qtd = [inputString integerValue];
										[pedido addItem:qtd:it];
									}else{
										printf("Não há item com código %d no cardápio.\n", codigo);
									}
								}
							}
						}
						double total = [pedido getTotal];
						system("clear");
						printf("Total: R$%.2f. Confirma?\n", total);
						input = [NSFileHandle fileHandleWithStandardInput];
						inputData = [NSData dataWithData:[input availableData]];
						inputString = [[NSString alloc] initWithData:inputData encoding:NSUTF8StringEncoding];
						inputString = [inputString stringByTrimmingCharactersInSet:[NSCharacterSet whitespaceAndNewlineCharacterSet]];
						if([inputString isEqualToString:@"S"] || [inputString isEqualToString:@"s"]){
							[pedido setEntregador: [control alocarEntregador]];
							[control addPedido:pedido];
						}
					}
					system("clear");
					printf("Novo Pedido:\n");
				}
				[control gerarRelatorio];
				//----------------Fim Corpo do Programa---------------------
			}else{
				printf("Arquivos de entrada não especificados.\nUse: -e <arquivo de entregadores> -c <arquivo do cardápio>\n");
			}
		}else{
			printf("Arquivos de entrada não especificados.\nUse: -e <arquivo de entregadores> -c <arquivo do cardápio>\n");
		}
	}else{
		printf("Arquivos de entrada não especificados.\nUse: -e <arquivo de entregadores> -c <arquivo do cardápio>\n");
	}
	[pool drain];
	return 0;
}