
/*
Files that must be included in order to use sockets 
*/

#include<sys/types.h>
#include<sys/socket.h>
#include<sys/un.h>
#include<netinet/in.h>
#include<arpa/inet.h>
/* Old stdio */
#include<stdio.h>
#include<stdlib.h>
#include<string.h>
#include<sys/times.h>
#include<sys/errno.h>
#include<unistd.h>
#include<fcntl.h>
#include<signal.h>
void 
error(char *s)
{

  printf("%s:%s\n", s,strerror(errno));
  exit(1);
}

#define BLCKSZ 100
#define NUMBLCKS 100

long buff[BLCKSZ];

void 
randblckgen(long *buff,int n)
{
  while (--n>0)
    buff[n]=lrand48();
}

int val=0;
int blockin=0;

int sfd;
struct sockaddr_in cli,serv;
socklen_t len = sizeof(struct sockaddr_in);

void 
sigio(int signo)
{
  
  if ((val=recvfrom(sfd,buff,sizeof(buff),0,(struct sockaddr *)&cli,&len)) < 0)
    error("recv\n");
  blockin=1;
}

int 
main(int argc,char **argv)
{
  int i,port,n;
  char str[150];
  sigset_t zero,new,old;

  srand48(13);
  sscanf(argv[1],"%d",&port);

  if ( (sfd=socket(AF_INET,SOCK_DGRAM,0)) < 0){
      error("socket creation\n");
    }
  serv.sin_family=AF_INET;
  serv.sin_port=htons(port);
  serv.sin_addr.s_addr=htonl(INADDR_ANY);

  bind(sfd,(struct sockaddr *)&serv,sizeof(serv));

  signal(SIGIO,sigio);
  fcntl(sfd,F_SETOWN,getpid());
  
  fcntl(sfd,F_SETFL,O_ASYNC);
  
  sigemptyset(&zero);
  sigemptyset(&old);
  sigemptyset(&new);
  sigaddset(&new,SIGIO);

  sigprocmask(SIG_BLOCK,&new,&old);
  for (i=0;i<NUMBLCKS;i++)
    {
      char strans[128];
      int n;
      clock_t ticks;
      
      while (!blockin)
	sigsuspend(&zero);

      sigprocmask(SIG_SETMASK,&old,0);

      ticks=times(0);
      printf("received block %d\n",i);
      sprintf(strans,"received %d at %d %d\n",val, ticks,sysconf(_SC_CLK_TCK));
      if (sendto(sfd,strans,sizeof(strans),0,(struct sockaddr *)&cli,len) < 0)
        error("sendto\n");
      printf("Sent: %s\n",strans);

      sigprocmask(SIG_BLOCK,&new,&old);
      blockin=0;
    }
  printf("\n");
  exit(0);
}


