/** \file blockingserv.c
 *<b> A server:</b>
* It opens a socket, and receives a series of messages through it.
*
* Compile it with:
* <b>gcc -o blocking blockingserv.c</b>
*
* Execute with:
* <b> ./blocking  60000 </b>
*
* The command line argument is the socket to be opened.
 */
#include<sys/types.h>
#include<sys/socket.h>
#include<sys/un.h>
#include<netinet/in.h>
#include<arpa/inet.h>

#include<sys/select.h>
#include<sys/time.h>

#include<stdio.h>
#include<errno.h>
#include<string.h>



void 
error(char *s)
{
  printf("%s\n", s);
  exit(1);
}

/* \recred: reading a block of \b n longs*/
int recread(int s, void *b, int n, int *f){
  int sz=0;
  int m;

  while ( (m=read(s,b+sz,n-sz)) >= 0){
    (*f)++;
    sz+=m;
    printf(">m%d:n%d:sz%d: ",m,n,sz);
    if (sz==n) return sz;
  }
  printf("pau:m>%d:sz%d=>%d\nError:%s\n",m,sz,errno,strerror(errno));
  return m;
}



#define BLCKSZ 10000
#define NUMBLCKS 100

long buff[BLCKSZ];

#define NUMGENS 5

enum protocol_state{W_NB,W_Bsz,W_B,B_E,W_End};

struct connstate{
  int id;
  int cd;
  enum protocol_state st;
  long nb;
  long bc;
  long bsz;
  long boset;
  long buff[BLCKSZ];
};

typedef struct connstate connstate_t;
void nextstate(connstate_t *cs){
  if (cs->st==W_NB){
    if (recv(cs->cd,&cs->nb,sizeof(long),MSG_WAITALL) < 0)
      exit(1);
    cs->st=W_Bsz;
    cs->bc=0;
  }
  else if (cs->st==W_Bsz){
    if (recv(cs->cd,&cs->bsz,sizeof(long),MSG_WAITALL) < 0)
      exit(1);
    cs->bsz*=sizeof(long);
    cs->st=W_B;
    cs->boset=0;
  }
  else if (cs->st==W_B){
    int n;
    if ( (n=read(cs->cd,((char*)cs->buff)+cs->boset,cs->bsz-cs->boset)) < 0)
      exit(1);
    cs->boset+=n;
    if (cs->boset==cs->bsz)
      cs->st=B_E;
  }
  else if (cs->st==B_E){
    int max=cs->buff[0];
    int i;
    for (i=1;i<cs->bsz/4;i++){
      if (cs->buff[i]>max) 
	max= cs->buff[i];
    }
    printf("con %d:block %d: min: %d\n",cs->id,cs->bc,max);
    cs->bc++;
    if (cs->nb==cs->bc){
      cs->st=W_End;
      close(cs->cd);
    }
    else
      cs->st=W_Bsz;
  }
}  

    
    

int 
main(int argc,char **argv)
{
  int lfd,cfd[NUMGENS];
  struct sockaddr_in serv;
  int port;
  int nfrags=0;
  int i;
  struct timeval timer;
  fd_set rset,wset,eset;
  connstate_t cs[NUMGENS];

  printf("a blocking socket\n");
  sscanf(argv[1],"%d",&port);
  /* creates socket, connection-oriented exchange */
  if ( (lfd=socket(PF_INET,SOCK_STREAM,0)) < 0)
   error("socket creation\n");
  serv.sin_family=AF_INET; /* internet protocol */
  serv.sin_port=htons(port); /* port number */

  /* accept connections from any address */
  serv.sin_addr.s_addr=htonl(INADDR_ANY); 


  /* bind socket to port */
  bind(lfd,(struct sockaddr*) &serv,sizeof(serv));

  /* accept up to 5 simultaneous connections */
  listen(lfd, NUMGENS);
  
  FD_ZERO(&rset);
  
  /* wait for 5 connections */  
  for (i=0;i<NUMGENS;i++){
    cs[i].cd=accept(lfd,0,0);
    cs[i].st=W_NB;
    cs[i].id=i;
    printf("%d accepetd\n",i);
  }


  for(;;){
    int on = 0;
    FD_ZERO(&rset);    
    for (i=0;i<NUMGENS;i++){
      if (cs[i].st!=W_End) {
	FD_SET(cs[i].cd,&rset);
	on=1;
      }
    }
    if (!on) break;
/*      printf("ready to select\n"); */
    if (select(10,&rset,0,0,0)< 0)
      exit(1);
    for (i=0;i<NUMGENS;i++){
      if ( FD_ISSET(cs[i].cd,&rset) )
	nextstate(cs+i);
    }
  }
       
  close(lfd);
  exit(0);
}




