/** \file blockingserv.c
 *<b> A server:</b>
* It opens a socket, and receives a series of messages through it.
*
* Compile it with:
* <b>gcc -o blocking blockingserv.c</b>
*
* Execute with:
* <b> ./blocking  60000 </b>
*
* The command line argument is the socket to be opened.
 */
#include<sys/types.h>
#include<sys/socket.h>
#include<sys/un.h>
#include<netinet/in.h>
#include<arpa/inet.h>
#include<stdio.h>
#include<errno.h>
#include<string.h>



void 
error(char *s)
{
  printf("%s\n", s);
  exit(1);
}

/* \recred: reading a block of \b n longs*/
int recread(int s, void *b, int n, int *f){
  int sz=0;
  int m;

  while ( (m=read(s,b+sz,n-sz)) >= 0){
    (*f)++;
    sz+=m;
    printf(">m%d:n%d:sz%d: ",m,n,sz);
    if (sz==n) return sz;
  }
  printf("pau:m>%d:sz%d=>%d\nError:%s\n",m,sz,errno,strerror(errno));
  return m;
}



#define BLCKSZ 10000
#define NUMBLCKS 100

long buff[BLCKSZ];

int 
main(int argc,char **argv)
{
  int lfd,cfd;
  struct sockaddr_in serv;
  int port;
  int nfrags=0;
  int i;

  printf("a blocking socket\n");
  sscanf(argv[1],"%d",&port);
  /* creates socket, connection-oriented exchange */
  if ( (lfd=socket(PF_INET,SOCK_STREAM,0)) < 0)
   error("socket creation\n");
  serv.sin_family=AF_INET; /* internet protocol */
  serv.sin_port=htons(port); /* port number */

  /* accept connections from any address */
  serv.sin_addr.s_addr=htonl(INADDR_ANY); 


  /* bind socket to port */
  bind(lfd,(struct sockaddr*) &serv,sizeof(serv));

  /* accept up to 5 simultaneous connections */
  listen(lfd, 1);
  
  /* wait for connection */  
  cfd=accept(lfd,0,0);

  for (i=0;i<NUMBLCKS;i++)
    {
      long size;
      if ( recv(cfd,&size,sizeof(long),MSG_WAITALL) == 0){
	close(cfd);
	close(lfd);
	exit(0);
      }

      if ( recv(cfd,buff,sizeof(long)*size,MSG_WAITALL) == 0){
	close(cfd);
	close(lfd);
	exit(0);
      }

      printf("block: %d nfrags:%d\n",i,nfrags);
    }
  close(cfd);
  close(lfd);
  exit(0);
}



