
/*
tcp/ip includes
*/

#include<sys/types.h>
#include<sys/socket.h>
#include<sys/un.h>
#include<netinet/in.h>
#include<arpa/inet.h>
/*
select include
*/
#include<sys/select.h>
/* Old standard libraries */
#include<stdio.h>
#include<stdlib.h>
/* needed to deal with error conditions */
#include<errno.h>
#include<string.h>

/* threads */
#include<pthread.h>

void error(char *s, int *sfd, int i){
  int j;
  for (j=0;j<i;j++) shutdown(sfd[i],2);
  printf("%s\n", s);
  exit(1);
}

/** \fn int sockarray(int *sfd, int n,int nsock);
 *
 */
int sockarray(int *sfd, int n,int nsock,char *xargv){
  struct sockaddr_in serv;
  int i;
  for (i=0;i<n;i++){
  /* Prepare sockets t connect with address  nsock 
   */
    if ( (sfd[i]=socket(PF_INET,SOCK_STREAM,0)) < 0){
      error("socket creation\n",sfd,i);
    }
    serv.sin_family=PF_INET;
    serv.sin_port=htons(nsock);

    /* converting address in format <b> xxx.xxx.xxx.xxx </b> contained
     *in \b xargv to an integer, saved in \b serv.sin_addr 
     */
    if (inet_pton(PF_INET,xargv,&serv.sin_addr)<=0)
      error(xargv,sfd,i);
    if (connect(sfd[i],(struct sockaddr*) &serv,sizeof(serv)) < 0)
      error("connect",sfd,i);
  }

  return 0;
}


/* \fn recwrite: write a block of \b n longs*/
int recwrite(int s, void *b, int n){
  int sz=0;
  int m;

  while ( (m=write(s,b+sz,n-sz)) >= 0){
    if (!m) return sz;
    printf("%d ",m);
    sz+=m;
    if (sz==n){
      printf("\n");
      return sz;
    }
  }
  printf("Error: %s\n",strerror(errno));
  return m;
}

#define BLCKSZ 10000
#define NUMBLCKS 100

long buff[BLCKSZ];

void 
randblckgen(long *buff,long n)
{
  while (--n>0)
    buff[n]=lrand48();
}

#define NUMGENS 1

int nt=0;
void *
genfun(void *arg)
{
  int sd = *(int *)arg;
  int i;
  int *ret = (int*) malloc(sizeof(int));

  printf("NT:%d\n",++nt);
  for (i=0;i<NUMBLCKS;i++){
    long size=lrand48()%BLCKSZ;
    long buff[BLCKSZ];
    send(sd,&size,sizeof(long),MSG_WAITALL);
    randblckgen(buff,size);
    if (send(sd,buff,size*sizeof(long),MSG_WAITALL) == -1)
      {
        printf("block %d:send error\n",i);
	close(sd);
	*ret=-1;
	pthread_exit(ret);
      }
  }
  close(sd);
  *ret=1;
  pthread_exit(ret);
}

  
int 
main(int argc,char **argv)
{
  int sfd[NUMGENS],i,port,n;
  char str[150];
  fd_set rset,wset,eset;
  struct timeval timeout;
  pthread_t tid[NUMGENS];
  int **ret = (int **) malloc(sizeof(int)*NUMGENS);

  printf("A a generator of blocks of rand numbers\n");
  srand48(clock());
  sscanf(argv[2],"%d",&port);


  sockarray(sfd,1,port,argv[1]);

  for (i=0;i<NUMGENS;i++)
    {
      if (pthread_create(&tid[i],0,&genfun,&sfd[i]) > 0)
	error("Thread creation",sfd,NUMGENS);
      printf("created %d of %d\n",i,NUMGENS);
      
    }

  for (i=0;i<NUMGENS;i++){
    pthread_join(tid[i],ret+i);
    printf("Result for i%d:\n",i,*ret[i]);
    close(sfd[i]);
  }


  return 0;
}


