/** \file cli.c
 *<b>The Client side:</b>
* It connects to a socket, and sends a series of messages through it.
*
* Compile it with:
* <b>gcc -o cli cli.c</b>
*
* Execute with:
* <b> ./cli 127.0.0.1 60000 </b>
*
* First command line argument is the machine IP you're trying to connect with,
and the second one is the port in that machine.
* By the way, you may even include complex \f$\mbox{\rm\TeX}\f$  formulae \f$x^2\f$ in a line.
 */

/*
Files that must be included in order to use sockets 
*/

#include<sys/types.h>
#include<sys/socket.h>
#include<sys/un.h>
#include<netinet/in.h>
#include<arpa/inet.h>
/* Old stdio */
#include<stdio.h>
#include<stdlib.h>
#include<errno.h>
#include<string.h>


void error(char *s, int *sfd, int i){
  int j;
  for (j=0;j<i;j++) shutdown(sfd[i],2);
  printf("%s\n", s);
  exit(1);
}

/** \fn int sockarray(int *sfd, int n,int nsock);
 *
 */
int sockarray(int *sfd, int n,int nsock,char *xargv){
  struct sockaddr_in serv;
  int i;
  for (i=0;i<n;i++){
  /* Prepare \b n sockets to connect with address \b nsock 
   */
    if ( (sfd[i]=socket(PF_INET,SOCK_STREAM,0)) < 0){
      error("socket creation\n",sfd,i);
    }
    serv.sin_family=PF_INET;
    serv.sin_port=htons(nsock);

    /* converting address in format <b> xxx.xxx.xxx.xxx </b> contained
     *in \b xargv to an integer, saved in \b serv.sin_addr 
     */
    if (inet_pton(PF_INET,xargv,&serv.sin_addr)<=0)
      error(xargv,sfd,i);
    if (connect(sfd[i],(struct sockaddr*) &serv,sizeof(serv)) < 0)
      error("connect",sfd,i);
  }

  return 0;
}


/* \fn recwrite: write a block of \b n longs*/
int recwrite(int s, void *b, int n){
  int sz=0;
  int m;

  while ( (m=write(s,b+sz,n-sz)) >= 0){
    if (!m) return sz;
    printf("%d ",m);
    sz+=m;
    if (sz==n){
      printf("\n");
      return sz;
    }
  }
  printf("Error: %s\n",strerror(errno));
  return m;
}

#define BLCKSZ 10000
#define NUMBLCKS 100

long buff[BLCKSZ];

void 
randblckgen(long *buff,int n)
{
  while (--n>0)
    buff[n]=lrand48();
}

int 
main(int argc,char **argv)
{
  int sfd,i,port,n;
  char str[150];

  printf("A a generator of blocks of rand numbers\n");
  srand48(13);
  sscanf(argv[2],"%d",&port);


  sockarray(&sfd,1,port,argv[1]);

  for (i=0;i<NUMBLCKS;i++)
    {
      randblckgen(buff,BLCKSZ);
      printf("block %d ",i);
      if ( recwrite(sfd, buff,sizeof(buff)) < 0)
	error("write",&sfd,5);
    }
  printf("\n");
  close(sfd);
  return 0;
}


