/** \file blockingserv.c
 *<b> A server:</b>
* It opens a socket, and receives a series of messages through it.
*
* Compile it with:
* <b>gcc -o blocking blockingserv.c</b>
*
* Execute with:
* <b> ./blocking  60000 </b>
*
* The command line argument is the socket to be opened.
 */
#include<sys/types.h>
#include<sys/socket.h>
#include<sys/un.h>
#include<netinet/in.h>
#include<arpa/inet.h>
#include<stdio.h>

#define MSG "A message"

void error(char *s){
  printf("%s\n", s);
  exit(1);
}

int recread(int s,char *b,int n){
  int sz=0,m;
  while ( (m=read(s,b+sz,n-sz)) >= 0){
    if (!m) return sz;
    if (b[sz+m-1]!='\n' && b[sz+m-2]!='\n')
      return sz+m;
    sz+=m;
  }
}

int main(int argc,char **argv){
  int lfd,cfd;
  struct sockaddr_in serv;
  char buff[128];
  int port;

  printf("a blocking socket\n");
  sscanf(argv[1],"%d",&port);
  /* creates socket, connection-oriented exchange */
  if ( (lfd=socket(PF_INET,SOCK_STREAM,0)) < 0)
   error("socket creation\n");
  serv.sin_family=AF_INET; /* internet protocol */
  serv.sin_port=htons(port); /* port number */
  serv.sin_addr.s_addr=htonl(INADDR_ANY); /* accept connections from any address */

  /* bind socket to port */
  bind(lfd,(struct sockaddr*) &serv,sizeof(serv));
  /* accept up to 5 simultaneous connections */
  listen(lfd, 5);
  
  cfd=accept(lfd,0,0);

  for (;;){
    /* wait for connection */

    if ( recread(cfd,buff,sizeof(buff)) == 0){
      /* Notice read will block until either:
            - something is available for reading
            - or the connection is cancelled out 
      */
/*        shutdown(cfd,0); */
/*        shutdown(lfd,0); */
      close(cfd);
      close(lfd);
      exit(0);
    }

    printf("got:%s\n",buff);
    if (!strcmp(buff,"processing time?")) {
      char clockstr[20];
      sprintf(clockstr,"%d",clock());
      printf("To reply: %s\n",clockstr);
      write(cfd,clockstr,strlen(clockstr)+1);
/*        shutdown(cfd,0); */
/*        shutdown(lfd,0); */
/*        exit(0); */
    }
    else{
      if (!strcmp(buff,"end")){
/*  	shutdown(cfd,0); */
/*  	shutdown(lfd,0); */
        close(cfd);
        close(lfd);
	exit(0);
      }
    }
  }
}


