/** \file cli.c
 *<b>The Client side:</b>
* It connects to a socket, and sends a series of messages through it.
*
* Compile it with:
* <b>gcc -o cli cli.c</b>
*
* Execute with:
* <b> ./cli 127.0.0.1 60000 </b>
*
* First command line argument is the machine IP you're trying to connect with,
and the second one is the port in that machine.
* By the way, you may even include complex \f$\mbox{\rm\TeX}\f$  formulae \f$x^2\f$ in a line.
 */

/*
Files that must be include in order to use sockets 
*/
#include<sys/types.h>
#include<sys/socket.h>
#include<sys/un.h>
#include<netinet/in.h>
#include<arpa/inet.h>
/* Old stdio */
#include<stdio.h>

char MSG[15]= "A message";


void error(char *s, int *sfd, int i){
  int j;
  for (j=0;j<i;j++) shutdown(sfd[i],2);
  printf("%s\n", s);
  exit(1);
}

/** \fn int sockarray(int *sfd, int n,int nsock);
 *
 */
int sockarray(int *sfd, int n,int nsock,char *xargv){
  struct sockaddr_in serv;
  int i;
  for (i=0;i<n;i++){
  /* Prepare \b n sockets to connect with address \b nsock 
   */
    if ( (sfd[i]=socket(PF_INET,SOCK_STREAM,0)) < 0){
      error("socket creation\n",sfd,i);
    }
    serv.sin_family=PF_INET;
    serv.sin_port=htons(nsock);

    /* converting address in format <b> xxx.xxx.xxx.xxx </b> contained
     *in \b xargv to an integer, saved in \b serv.sin_addr 
     */
    if (inet_pton(PF_INET,xargv,&serv.sin_addr)<=0)
      error(xargv,sfd,i);
    if (connect(sfd[i],(struct sockaddr*) &serv,sizeof(serv)) < 0)
      error("connect",sfd,i);
  }

  return 0;
}


int recread(int s,char *b,int n){
  int sz=0,m;
  while ( (m=read(s,b+sz,n-sz)) >= 0){
    if (!m) return sz;
    if (b[sz+m-1]!='\n' && b[sz+m-2]!='\n')
      return sz+m;
    sz+=m;
  }
}

#define MSGEND "end"
#define PROCTIME "processing time?"
int main(int argc,char **argv){
  int sfd,i,port,n;
  char str[150];

  printf("A client\n");

  sscanf(argv[2],"%d",&port);


  sockarray(&sfd,1,port,argv[1]);

  if (write(sfd,PROCTIME,sizeof(PROCTIME)) != sizeof(PROCTIME))
      error("write",&sfd,5);
  /* We should be reading in a loop: on account of tcp fragmentation, but
     we'll bet it won't */

  if ((n=recread(sfd,str,sizeof(str)-1)) >= 0){
    str[n]=0;
    printf("Received: |%s|\n",str);
  }
  else exit(1);  
  
  close(sfd);
  return 0;
}


