module BTreeTime where 

import System.Random
import System.CPUTime
import Data.List(sort,insert)
import BTree

rollDice :: Int->Int->IO Int
rollDice l u = getStdRandom (randomR (l,u))

alist :: forall t. (Integral t) => IO Int->t->[Int]->IO [Int]
alist _ 0 acc = return acc
alist dice (n+1) acc = dice >>= \i -> alist dice n (i:acc)

aSortedList :: forall t.(Integral t) => (IO Int) -> t -> IO [Int]
aSortedList dice n = (alist dice n []) >>= \xs -> return (sort xs) 

btreeTest t xs = foldl BTree.insert t xs

listinsert xs a = Data.List.insert a xs
listTest ls xs = foldl listinsert ls xs


