
module Pqgreedy where


import Point
--import List
import KDTree
import Greedy

mergeC::(Ord a)=> Binpq (ComparaDist a) ->Binpq(ComparaDist a) ->Binpq (ComparaDist a)
mergeC Vazio y = y
mergeC x Vazio = x
mergeC (No (CompDist p1 p2 d) x y) (No (CompDist p3 p4 e) u v)
       | d < e = No (CompDist p1 p2 d) (mergeC y (No (CompDist p3 p4 e) u v)) x
       | otherwise = No (CompDist p3 p4 e) (mergeC (No(CompDist p1 p2 d) x y) v ) u

--Insercao em uma Arvore de Prioridade

insertC::(Ord a)=>Binpq (ComparaDist a)->(ComparaDist a)->Binpq (ComparaDist a)
insertC Vazio b = No b Vazio Vazio
insertC h x = mergeC h (No x Vazio Vazio)

--Retorna o Minimo de uma Arvore de Prioridade

findminC::(Ord a)=>Binpq (ComparaDist a)->(ComparaDist a)
findminC (No a x y) = a

--Deleta o menor elemento da Arvore de Prioridade

delminC::(Ord a)=>Binpq (ComparaDist a)->Binpq(ComparaDist a)
delminC Vazio = Vazio
delminC (No a x y) = mergeC x y

montaAresta2 ::(Ord a,Num a)=>[Point a]->KDtree a->Binpq (ComparaDist a)->Binpq (ComparaDist a)
montaAresta2 [] kdtree binpq = binpq
montaAresta2 (x:xs) kdtree binpq = montaAresta2 xs kdtree (insertC binpq aresta)
	where
		kdtreed = delete x kdtree
		pontoproximo = findnn x kdtreed
		aresta  = (CompDist x pontoproximo (distancia x pontoproximo))		

parceiro::(Ord a,Num a)=>ComparaDist a->Point a->Point a
parceiro (CompDist a b d) c = if(c==a) then b else a 

um_grau2pq::(Ord a,Num a)=>[[Point a]]->ComparaDist a->Point a
um_grau2pq [] aresta = (-1,-1)
um_grau2pq ys aresta = 
		if (elem (ponto1 aresta) (init (tail(head ys)))) 
		then ponto2 aresta
		else  if( elem (ponto2 aresta) (init (tail(head ys))))
		      then  ponto1 aresta     	
	              else um_grau2pq (tail ys) aresta

dois_grau2pq::(Ord a)=>[[Point a]]->ComparaDist a->Bool
dois_grau2pq [] aresta = False
dois_grau2pq ys aresta = 
		if (elem (ponto1 aresta) (init (tail(head ys))) && elem (ponto2 aresta) (init (tail(head ys))))
		    then True	
    	
      	    else dois_grau2pq (tail ys) aresta

auxpqgredy::(Ord a, Num a)=>Binpq (ComparaDist a)->KDtree a->[[Point a]]->[[Point a]]
auxpqgredy Vazio kdtree tour = tour 
auxpqgredy binpq kdtree tour = 
	if (not (status kdtree))
	then tour 
	else	if (grau2 tour aresta)
	    	then	auxpqgredy (insertC nova_binpq nova_aresta) nova_kdtree_parceiro tour
		else	if (fechatour tour aresta) 
		     	then	if((ponto1 aresta)==vizinho1)
				then auxpqgredy nova_binpq kdtree_ponto1 (juntatour ([(ponto1 aresta)]:tour) (length([(ponto1 aresta)]:tour))) 	
				else auxpqgredy nova_binpqfechatour kdtree tour
		     	else auxpqgredy nova_binpq kdtree (juntatour ((pontos aresta):tour) (length((pontos aresta):tour)))	
	 
	where 
		aresta = findminC binpq
		nova_binpq = delminC binpq
		nova_kdtree2 = delete (ponto1 aresta) (delete (ponto2 aresta) kdtree)

		vizinho1 = findnn (ponto1 aresta) nova_kdtree2
		nova_aresta1 = CompDist (ponto1 aresta) vizinho1 (distancia vizinho1 (ponto1 aresta)) 
		nova_binpqfechatour = insertC nova_binpq nova_aresta1
		kdtree_pontonovo2 = (delete (ponto2 nova_aresta) kdtree)

		kdtree_ponto1 = (delete (ponto1 aresta) kdtree)

		kdtree_ponto2 = (delete (ponto2 aresta) kdtree)
   	        ponto = um_grau2pq tour aresta         -- ponto q ñ e grau2
		parceiroponto = parceiro aresta ponto  -- ponto q eh grau2
		nova_kdtree_parceiro = delete parceiroponto kdtree --deleta o d grau2
		vizinho = findnn ponto nova_kdtree2
		nova_aresta= CompDist ponto vizinho (distancia ponto vizinho)

pqgredy::(Ord a,Num a)=>[Point a]->[Point a]
pqgredy [] = []
pqgredy pontos = head(auxpqgredy binpq kdtree [])
	where
		kdtree = build pontos
		binpq = montaAresta2 pontos kdtree Vazio
