module Binpq where

import Point
import List
import Control.Exception
import System.IO

data Binpq a = Vazio
              |No a (Binpq a) (Binpq a)
  deriving Show


merge::(Ord a)=> Binpq a ->Binpq a ->Binpq a
merge Vazio y = y
merge x Vazio = x
merge (No a x y) (No b u v)
       | a < b = No a (merge y (No b u v)) x
       | otherwise = No b (merge (No a x y) v ) u

--Insercao em uma Arvore de Prioridade
insert::(Ord a)=>Binpq a->a->Binpq a
insert Vazio b = No b Vazio Vazio
insert h x = merge h (No x Vazio Vazio)

--Retorna o Minimo de uma Arvore de Prioridade
findmin::(Ord a)=>Binpq a->a
findmin Vazio = error "Arvore Vazia"
findmin (No a x y) = a

--Deleta o menor elemento da Arvore de Prioridade
delmin :: (Ord a) => Binpq a -> Binpq a
delmin Vazio = Vazio
delmin (No a x y) = merge x y


aux::(Ord a)=>a->Binpq a->Bool
aux c Vazio = False
aux c y     = True

--Funcao responsavel por verificar se a arvore passada eh  uma Arvore de Prioridade
isbinpq::(Ord a)=>Binpq a->Bool
isbinpq Vazio = True
isbinpq (No a Vazio y) =         
		if((aux a y)==False) 
		then True
	        else if(a<=findmin y) 
	             then isbinpq y 
	             else False

isbinpq (No a x Vazio) = 
	        if((aux a x)==False) 
		then True
                else if (a<=findmin x) 
		     then isbinpq x 
		     else False

isbinpq (No a x y) =  
		 if ((a<=findmin x)&& (a <= findmin y))
		 then isbinpq (merge x y)
        	 else False


