module Nn where


import Point
import KDTree

import List
import Control.Exception
import System.IO


-- **************** funções Auxiliares do Nn *******************************


--Deleta um elemento de uma lista
deleteList :: (Ord a) => a -> [a] -> [a]
deleteList x xs = [a | a <- xs, a /= x]


arvoreProximo::(Ord a,Num a)=>Point a->[Point a]->Binpq (Dist a)->Binpq (Dist a)
arvoreProximo ponto [] arvore = arvore
arvoreProximo ponto (x:xs) arvore  = arvoreProximo ponto xs (insertDist arvore novoponto)
		where 
			novoponto = (P x (distancia ponto x))


	
auxnn::(Ord a, Num a)=>[Point a]->Point a->[Point a]
auxnn [] ponto = []
auxnn xs ponto =  novoponto:auxnn vetorsemponto novoponto
		where
			arvoreproximo = arvoreProximo ponto (xs) Vazio
			novoponto = pontodist(findminDist arvoreproximo)
			vetorsemponto = deleteList novoponto xs


--Funcao principal da heuristica Nn

nn::(Ord a,Num a)=>[Point a]->[Point a]
nn [] = []
nn xs = y:(auxnn ys y)
	where
		(y:ys) =ordena xs True

-- **************** funçoes Auxiliar do istour *******************************
isTourAx::(Num a,Ord a)=>[Point a]->Point a->Bool
isTourAx [] a = True
isTourAx (x:xs) pontoPivo
       |distanciaP <= distancianova = isTourAx (xs)x
       |otherwise = False
       where	
        arvoreproximo = arvoreProximo pontoPivo (x:xs) Vazio	
        distancianova = dist(findminDist arvoreproximo)
	distanciaP = distancia x pontoPivo	


--Verifica se o tour verdadeiro
isTour::(Num a,Ord a)=>[Point a]->Bool
isTour (x:xs) = isTourAx (xs) x



{-
main = readIntPts [] >>= \pts -> let tour = nn pts
                                 in putStr (showPoints (tour))
-}
