module KDTree where

import Point


import Control.Exception
import System.CPUTime

--Definindo os dados

data Binpq a = Vazio
              |No a (Binpq a) (Binpq a)
  deriving Show


data KDtree a  = Null
 	               |Leaf [(New_Point a)]
                       |Node Bool a Bool (KDtree a) (KDtree a)
  deriving Show

data New_Point a = Ponto (Point a) Bool
  deriving Show

data Compara a = Comp Bool Bool a
  deriving Show

data Dist a = P (Point a) a
  deriving Show

dist(P a d) = d
pontodist(P a d) = a

-- **************** funções Auxiliares do Build *******************************

--Retorna o Minimo de uma Arvore de Prioridade
findminDist:: (Ord a)=>Binpq (Dist a)->(Dist a)
findminDist Vazio = error "Vazio"
findminDist (No a x y) = a

insertDist :: (Ord a)=>Binpq (Dist a)->(Dist a)->Binpq (Dist a)
insertDist Vazio b = No b Vazio Vazio
insertDist h x = mergeDist h (No x Vazio Vazio)

mergeDist::(Ord a) => Binpq (Dist a) ->Binpq (Dist a) ->Binpq (Dist a)
mergeDist Vazio y = y
mergeDist x Vazio = x
mergeDist (No a x y) (No b u v)
       | (dist a) < (dist b) = No a (mergeDist y (No b u v)) x
       | otherwise = No b (mergeDist (No a x y) v ) u


-- Coordenadas do Ponto
xcoord (x,y) = x
ycoord (x,y) = y

yponto (Ponto (x,y) z) = y
xponto (Ponto (x,y) z) = x

-- Calcula a distância entre dois pontos
distancia::(Num a)=>(Point a)->(Point a)->a
distancia x y = ((xcoord(x)-xcoord(y))^2) + ((ycoord(x)-ycoord(y))^2)

-- Ordena pela coordenada x
quicksortX::(Ord a)=>[Point a]->[Point a]
quicksortX []     = []
quicksortX (p:xs) = quicksortX [ x | x <- xs, xcoord(x) <= xcoord(p) ]
                  ++ [ p ] ++
                  quicksortX [ x | x <- xs, xcoord(x) >  xcoord(p) ]

-- Ordena pela coordenada y
quicksortY::(Ord a)=>[Point a]->[Point a]
quicksortY []     = []
quicksortY (p:xs) = quicksortY [ x | x <- xs, ycoord(x) <= ycoord(p) ]
                  ++ [ p ] ++
                  quicksortY [ x | x <- xs, ycoord(x) >  ycoord(p) ]

-- Ordena pela linha de particionamento atual , dado pelo Boolean
ordena::(Ord a)=>[Point a]->Bool->[Point a]
ordena b c  = 
        if c 
	then  quicksortX b
        else  quicksortY b

-- Pega a posição do Pivot
posPivot::(Ord a)=>[Point a]->Bool->Int->Int
posPivot x b p =
	if b
	then	
		if (xcoord(x!!p) == xcoord(x!!(p+1)))
		then posPivot x b (p+1)
		else p
	else	
		if (ycoord(x!!p) == ycoord(x!!(p+1)))
		then posPivot x b (p+1)
		else p

-- Pega o Valor da Posição
pivot::(Ord a)=>[Point a]->Bool->Int->a
pivot x c  p= if c then d
       else e
       where d =  xcoord(x !! p)
             e =  ycoord(x !! p)

--Pegando os maiores elementos de um dado Valor numa Lista
maiorValor::(Ord a)=>[Point a]->a->Bool->[Point a]
maiorValor []  c b = []
maiorValor (a:x) c b =
	if b
	then	
		if (xcoord(a) > c)
		then a:maiorValor x c b
                else maiorValor x c b
        else	
		if (ycoord(a) > c)
		then a:maiorValor x c b
                else maiorValor x c b

--Pegando os menores elementos de um dado Valor numa Lista
menorValor::(Ord a)=>[Point a]->a->Bool->[Point a]
menorValor [] c b = []
menorValor (a:x) c b =
	if b
	then
	    	if (xcoord(a) <= c)
		then a:menorValor x c b
                else menorValor x c b

        else	if (ycoord(a) <= c)
		then a:menorValor x c b
                else menorValor x c b

-- Cria Folha com Pontos com a Nova Estrutura (New_Point a)
criaFolha::(Ord a)=>[Point a]->[New_Point a]
criaFolha [] = []
criaFolha (x:xs)= (Ponto x True):criaFolha xs
			
-- Função principal do Build
function::(Ord a)=>[Point a]->Bool->KDtree a
function [] d = Null
function x d
        |(length x)<= 8 = Leaf (criaFolha x)
        |otherwise= Node d p True (function menorigual (not d)) (function maior (not d))
               where
                  v = ordena x d
		  posicao = posPivot v d ((div (length x) 2)-1)	
		  p = pivot v d posicao
	          menorigual = take (posicao+1) v
                  maior =  drop (posicao+1) v

		 
-- ******************* Build ***********************************************************

build ::(Ord a)=>[Point a]->KDtree a
build [] = Null
build xs = function xs True



-- ************* Funcões Auxiliares do isKDtree ***************************************

compara::(Ord a,Num a)=>Compara a->[New_Point a]->Bool
compara y [] = True
compara (Comp a b c) (x:xs) =
 		if a
                then  	if b
                 	then   	if (xponto(x)<= c)
                        	then compara (Comp a b c) xs
                          	else False
                        else
			  	if (xponto(x)> c)
                          	then compara (Comp a b c) xs
                          	else False
                else
			if b
                        then   	if (yponto(x)<= c)
                          	then compara (Comp a b c) xs
                          	else False
                        else
                        	if (yponto(x)> c)
                        	then compara (Comp a b c) xs
                          	else False

comparaBuilder::(Ord a,Num a)=>[Compara a]->[New_Point a]->Bool
comparaBuilder [] ys = True
comparaBuilder (x:xs) ys =
	if(compara x ys) 
	then comparaBuilder xs ys
        else False

func::(Ord a,Num a)=>KDtree a->[Compara a]->Bool
func (Leaf []) xs = False
func (Leaf a) xs = comparaBuilder xs a
func (Node b v b1 l r) xs =
	if((func l d) && (func r e))
        then True
	else False

		where
                	d = (Comp b True v):xs
			e = (Comp b False v):xs


-- ........................ isKDtree ................................................

isKDtree::(Ord a,Num a)=>KDtree a->Bool
isKDtree Null = True
isKDtree (Leaf v)= if (length v == 0) || (length v > 8) then False else True
isKDtree tree = func tree []


-- ******************** Funcões Auxiliares do Findnn ********************************

-- Verifica se a árvore não está toda deletada
status Null = False
status (Leaf v) = if ((length(apenasTrue v))==0) then False else True
status (Node b v b1 left right) = b1

pontoProximo::(Ord a,Num a)=>Point a->[Point a]->Binpq (Dist a)->Point a
pontoProximo ponto [] arvore = pontodist(findminDist arvore)
pontoProximo ponto (x:xs) arvore  =
	if ((length (x:xs))>0)
	then pontoProximo ponto xs (insertDist arvore novoponto)
	else ponto
		where 
			novoponto = (P x (distancia ponto x))

filtro::(Ord a, Num a)=>Point a->KDtree a->[Point a]
filtro ponto Null = []
filtro ponto (Leaf v) = apenasTrue v
filtro ponto (Node a b True left right) =  (auxfindnn ponto left)++(auxfindnn ponto right)

-- Verifica se a árvore é folha
verificafolha::(Ord a)=>KDtree a->Bool
verificafolha (Leaf v) = True
verificafolha (Node b v b1 l r) = False

-- Pega somente os elementos com Boolean True na lista
apenasTrue::(Ord a)=>[New_Point a]->[Point a]
apenasTrue [] =[]
apenasTrue (x:xs)= 
	if (soBool(x))
	then soPonto(x):apenasTrue xs
	else apenasTrue xs	

-- Função principal do Findnn
auxfindnn::(Ord a)=>Point a->KDtree a->[Point a]
auxfindnn ponto Null = []
auxfindnn ponto (Node b v False left right )= []
auxfindnn ponto (Node b v True left Null ) = auxfindnn ponto left
auxfindnn ponto (Node b v True Null right ) = auxfindnn ponto right	
auxfindnn ponto (Leaf c) = apenasTrue c
auxfindnn ponto (Node b v True (Leaf c) (Leaf d)) = apenasTrue(c++d)

auxfindnn ponto (Node b v True left right)=
	if b
	then	if(xcoord(ponto)<=v)
		then	
			if (verificafolha left)
			then auxfindnn ponto left
		      	else	
				if (status left)
				then auxfindnn ponto left
		        	else auxfindnn ponto right
		else	
			if (verificafolha right)
			then auxfindnn ponto right
		      	else	if (status right)
				then auxfindnn ponto right
		        	else auxfindnn ponto left
 
	else	if(ycoord(ponto)<=v)
		then	
			if (verificafolha left)
			then auxfindnn ponto left
		      	else	
				if (status left)
				then auxfindnn ponto left
		        	else auxfindnn ponto right
		else	
			if (verificafolha right)
			then auxfindnn ponto right
		      	else	
				if (status right)
				then auxfindnn ponto right
		        	else auxfindnn ponto left





-- .................... Findnn ...............................................

findnn::(Ord a,Num a)=>Point a->KDtree a->Point a
findnn ponto Null = error "Arvore Vazia!!"
findnn ponto arvore  = if (status arvore)&&((length pontos) /= 0)
		       then pontoProximo ponto pontos Vazio
		       else ponto
		where 
		 pontos = (filtro ponto arvore)


-- ******************** Funcões Auxiliares do delete ********************************

soPonto (Ponto p z) = p
soBool  (Ponto p z) = z

-- Retorna o elemento mais perto de um determinado Ponto
mais_perto::(Num a ,Ord a)=>[(New_Point a)]->Point a->New_Point a
mais_perto (x:xs) p  =
       if(length xs == 0)
       then x                  
       else	if ((distancia (soPonto x) p)<=(distancia (soPonto (head(xs))) p) )
          	then mais_perto (x:tail xs) p
          	else mais_perto xs p                                                

pontos_lista::(Num a ,Ord a)=>[(New_Point a)]->[Point a]
pontos_lista [] = []
pontos_lista (x:xs) = (soPonto x) : pontos_lista xs

-- Retorna a posição de um elemento numa lista
pos_elem::(Num a,Ord a)=>Point a->[Point a]->Int
pos_elem p [] = -1
pos_elem p (x:xs) = 
        if (elem p (x:xs)) 
        then	if(p==x)
		then 0
		else (1+ pos_elem p xs) 
        else -1

--Reconstroi a arvore após o Delete
recBuilder::(Ord a,Num a)=>KDtree a->KDtree a
recBuilder Null = Null
recBuilder (Node b v True Null Null) = (Node b v False Null Null)

recBuilder (Node b v True (Leaf vl) Null)= if ((length(apenasTrue vl))==0)
					   then (Node b v False (Leaf vl) Null)
					   else (Node b v True (Leaf vl) Null)	

recBuilder (Node b v True Null (Leaf vl))= if ((length(apenasTrue vl))==0)
					   then (Node b v False Null (Leaf vl))
					   else (Node b v True  Null (Leaf vl))	

recBuilder (Node b v True Null right)= if ((status right)==False)
				       then (Node b v False Null right)
				       else (Node b v True  Null right)	

recBuilder (Node b v True right Null)= if ((status right)==False)
				       then (Node b v False right Null)
				       else (Node b v True right Null )	

recBuilder (Node b v True (Leaf vl)(Leaf vr)) = 
			if (((length(apenasTrue vl))==0) && ((length(apenasTrue vr))==0))
			then (Node b v False (Leaf vl)(Leaf vr))
			else (Node b v True (Leaf vl)(Leaf vr))	

recBuilder (Node b v True (Leaf vl) right)= 
				if (((length(apenasTrue vl))==0)&&((status right)==False))
				then (Node b v False (Leaf vl) right)
				else (Node b v True (Leaf vl)  right)	

recBuilder (Node b v True right (Leaf vl))= 
				if(((length(apenasTrue vl))==0)&&((status right)==False))
				then (Node b v False right (Leaf vl))
				else (Node b v True  right (Leaf vl))	

recBuilder (Node b v True left right) =
				if (((status left)==False)&&((status right)==False)) 
	                        then (Node b v False left right) 
	                        else (Node b v True left right)

--Função que deleta um elemento na arvore
delete::(Ord a,Num a)=>Point a->KDtree a->KDtree a
delete a Null = Null
delete a (Leaf v ) = 
        if (elem a (pontos_lista v))
        then    if (soBool(mais_perto v a)==False)
                then Leaf v
                else Leaf (ate_ponto ++ [(Ponto a False)] ++ drop ((length ate_ponto)+1) v )
        else Leaf v        
                        
                   where 
                        ate_ponto = take (pos_elem a (pontos_lista v)) v

delete a (Node b v True left right)  =      
                if b
                then    
			if (xcoord(a) <= v )
                        then  recBuilder ((Node b v True (delete a left) right))
                        else  recBuilder ((Node b v True left (delete a right)))
                else    
			if (ycoord(a) <= v )
                        then  recBuilder((Node b v True (delete a left) right))
                        else  recBuilder((Node b v True  left (delete a right))) 


delete a (Node b v False left right) = (Node b v False left right)

