module Greedy where

import Point
import KDTree
import List
import Control.Exception
import System.CPUTime

tam_aresta(CompDist a b d)=d
ponto1 (CompDist a b d)=a
ponto2 (CompDist a b d)=b
pontos (CompDist a b d)=[a,b]


data ComparaDist a = CompDist (Point a) (Point a) a
 deriving(Show)

auxCriaAresta::(Ord a,Num a)=>Point a->[Point a]->[ComparaDist a]
auxCriaAresta ponto [] = []
auxCriaAresta ponto (x:xs)= (CompDist ponto x (distancia ponto x)):auxCriaAresta ponto xs


--Cria Aresta
criaAresta::(Ord a,Num a)=>[Point a]->[ComparaDist a]
criaAresta [] =[]
criaAresta (x:xs)= isort (auxCriaAresta x xs) ++criaAresta xs


isort :: (Ord a )=> [ComparaDist a] -> [ComparaDist a]
isort []     = []
isort (x:xs) = insert1 x (isort xs)

insert1 :: (Ord a)=> ComparaDist a -> [ComparaDist a] -> [ComparaDist a]
insert1 x [] = [x]
insert1 x (y:xs)
	| tam_aresta(x) <= tam_aresta(y) = x : y : xs
	| otherwise = y : insert1 x xs

avalia::(Ord a,Num a)=>[[Point a]]->ComparaDist a ->[[Point a]]
avalia [] ponto =  [pontos ponto]
avalia xs ponto=
 	if (grau2 xs ponto)
	then xs
	else	if(fechatour xs ponto)
	        then xs
	   	else juntatour ((pontos(ponto)):xs) ((length xs)+1)

juntatour::(Ord a)=>[[Point a]]->Int->[[Point a]]
juntatour (x:[]) i = [x]
juntatour xs 0 = xs
juntatour (x:xs) i =
		if ((head x) == (head (head xs)))
		then juntatour (((reverse (head xs))++(tail x)):(tail xs)) (i-1)
	        else	if ((head x)  == (last (head xs)))
                      	then juntatour (((head xs)++(tail x)):(tail xs)) (i-1)
			else if ((last x) == (head (head xs)))
			     then juntatour (((init x)++(head xs)):(tail xs)) (i-1)
		             else  if ((last x)  /= (last (head xs)))
	   	                   then juntatour ((x:(tail xs))++[(head xs)]) (i-1)
				   else juntatour (((init x)++(reverse (head xs))):(tail xs)) (i-1)

grau2::(Ord a)=>[[Point a]]->ComparaDist a->Bool
grau2 [] aresta = False
grau2 ys aresta =
		if (elem (ponto1 aresta) (init (tail(head ys))) || elem (ponto2 aresta) (init (tail(head ys))))
		    then True	    	
		    else grau2 (tail ys) aresta


fechatour::(Ord a)=>[[Point a]]->ComparaDist a->Bool
fechatour [] aresta = False
fechatour (x:xs) aresta = 
		if ((head x)== (ponto1 aresta))&&((last x)== (ponto2 aresta))
		then True
		else
         		if ((head x)== (ponto2 aresta))&&((last x)== (ponto1 aresta))
			then True
			else fechatour xs aresta

greedy::(Ord a,Num a)=>[Point a]->[Point a]
greedy [] = []
greedy pontos = head(montatodostour [] (criaAresta pontos))

montatodostour::(Ord a,Num a)=>[[Point a]]->[ComparaDist a] ->[[Point a]]
montatodostour v [] = v
montatodostour v (x:xs) = montatodostour (avalia v x) xs
