module Frp where

import Point
import Nn
import KDTree
import Control.Exception
import System.CPUTime





 
-- **************** funções Auxiliares do FRP *******************************

--função responsavel por unir duas listas (folhas da KDTree)
mergeLists::(Num a,Ord a)=>[Point a]->[Point a]->Bool->[Point a]
mergeLists [] ys b = ys
mergeLists xs [] b = xs
mergeLists (x:xs) (y:ys) b =
		      if b then
			      if (xcoord(x) <= xcoord(y))
        	              then x : mergeLists xs (y:ys) b
        	              else y : mergeLists (x:xs) ys b
		      else
			      if (ycoord(x) <= ycoord(y))
        	              then x : mergeLists xs (y:ys) b
        	              else y : mergeLists (x:xs) ys b



--função responsabel por montar o tour usando a heuristica Frp
auxFrp::(Num a,Ord a)=>KDtree a->[Point a]
auxFrp (Leaf a) = nn (apenasTrue a)
auxFrp (Node b a b1 left right)=mergeLists (auxFrp left) (auxFrp right) b

--Funcao principal da heuristica frp

frp::(Num a,Ord a)=>[Point a]->[Point a]
frp [] =[]
frp vetor = auxFrp(build(vetor))




