module Binpq where

data (Ord a, Read a, Show a) => 
	Binpq a =	Leaf	-- folha
			| Noh (Binpq a) a (Binpq a)	--no interno
	deriving (Eq,Read,Show)

merge :: (Ord a, Read a, Show a) => Binpq a -> Binpq a -> Binpq a
merge x Leaf = x
merge Leaf x = x
merge (Noh x y z) (Noh a b c) =	if y<b
				then Noh (merge z (Noh a b c)) y x
				else Noh (merge (Noh x y z) c) b a

insert :: (Ord a, Read a, Show a) => Binpq a -> a -> Binpq a
insert Leaf x = Noh Leaf x Leaf
insert (Noh Leaf a c) x =	if x<a
				then Noh (insert Leaf a) x c
				else Noh (insert Leaf x) a c
insert (Noh c a Leaf) x =	if x<a
				then Noh (insert Leaf a) x c
				else Noh (insert Leaf x) a c
insert (Noh b a c) x =	if x<a
			then Noh (insert c a) x b
			else Noh (insert c x) a b

min :: (Ord a, Read a, Show a) => Binpq a -> a
min (Noh a b c) = b

pega_min ::(Show a,Read a,Ord a) => Binpq a -> a
pega_min a = Binpq.min a

delmin :: (Ord a, Read a, Show a) => Binpq a -> Binpq a
delmin (Noh a b c) = merge a c

isbinpq :: (Ord a, Read a, Show a) => Binpq a -> Bool
isbinpq (Noh Leaf b Leaf) = True
isbinpq (Noh (Noh d e f) b Leaf) = (b<e) && (isbinpq (Noh d e f))
isbinpq (Noh Leaf b (Noh d e f)) = (b<e) && (isbinpq (Noh d e f))
isbinpq (Noh (Noh d e f) b (Noh g h i)) = (b<e) && (b<h) && (isbinpq (Noh d e f)) && (isbinpq (Noh g h i))

tva [] = Leaf
tva (a:lista) = insert (tva lista) a
