module Ponto where

-- import module 'System.IO' that defines IO functions
import System.IO

-- O ponto a eh definido como um par de coordenadas =o]
type Ponto a = (a,a)

-- 'readpoints' maps a list of 'String' to an 'IO' list of 'Point a'
--  'a' is restricted by '(Read a)' to be readable

lePontos :: (Read a) => [String] -> IO [Ponto a]


lePontos xs = isEOF >>= \eof -> if eof
                                  then return (map read (reverse xs))
                                  else getLine >>= \ln -> lePontos (ln:xs)

-- 'readIntPts' is a specific instance of 'readPoints' to read points with
--              Int coordinates
lePontosInt :: [String] -> IO [Ponto Int]
lePontosInt = lePontos

distancia :: (Floating b) => (Ponto Int, Ponto Int) -> b
distancia (p0,p1) = sqrt(fromIntegral (sqrdist (p0,p1)))

sqrdist :: (Ponto Int, Ponto Int) -> Int
sqrdist ((x0,y0), (x1,y1)) = (x0-x1)^2+(y0-y1)^2


-- 'showPoints' points list to String 

mostraPontos :: (Show a) => [Ponto a] -> String
mostraPontos pts = unlines (map show pts)
