module KDTree where

import Point

data (Ord a, Read a, Show a) => 
	KDtree a =	Leaf [Point a]	-- folha
			| Node Char a (KDtree a) (KDtree a)	--no interno
	deriving (Eq,Read,Show)

coordenada dimensao (x,y) =	if dimensao == 'x'
				then x
				else y

pega_posicao y lista =	if (length menores) < y
			then 	if (length menores) + (length iguais) >= y
				then head iguais
				else pega_posicao (y-(length menores)-(length iguais)) maiores
			else pega_posicao y menores
	where
	menores = [ x | x<-lista , x<(head lista) ]
	iguais = [ x | x<-lista , x==(head lista) ]
	maiores = [ x | x<-lista , x>(head lista) ]

escolhe_p dimensao lista = pega_posicao (div (length lista) 2) [ coordenada dimensao x | x<-lista ]

pega_maior dimensao numero lista = [ (x,y) | (x,y)<-lista , (coordenada dimensao (x,y)) > numero ]
pega_menor dimensao numero lista = [ (x,y) | (x,y)<-lista , (coordenada dimensao (x,y)) <= numero ]

build :: (Ord a, Read a, Show a) => [Point a] -> (KDtree a)
build s = build2 'x' s

build2 dimensao s =	if length s <= 8
			then Leaf s
			else Node dimensao p (build2 muda menores) (build2 muda maiores)
	where
	p = escolhe_p dimensao s
	menores = pega_menor dimensao p s
	maiores = pega_maior dimensao p s
	muda =	if dimensao == 'x'
		then 'y'
		else 'x'

isKDtree :: (Ord a, Read a, Show a) => KDtree a -> Bool
isKDtree (Leaf x ) = length x <= 8
isKDtree (Node dimensao p (Leaf x) (Leaf y)) = (isKDtree (Leaf x)) && (isKDtree (Leaf y)) && (pega_menor dimensao p x == x) && (pega_maior dimensao p y == y)
isKDtree (Node dimensao p (Leaf x) (Node d1 p1 te1 td1) ) =
	if dimensao == d1
	then False
	else (isKDtree te1) && (isKDtree (Node d1 p1 te1 td1)) && (pega_menor dimensao p x == x)
isKDtree (Node dimensao p (Node d1 p1 te1 td1) (Leaf x) ) =
	if dimensao == d1
	then False
	else (isKDtree td1) && (isKDtree (Node d1 p1 te1 td1)) && (pega_maior dimensao p x == x)
isKDtree (Node dimensao p (Node d1 p1 te1 td1) (Node d2 p2 te2 td2) ) =
	if (dimensao == d1) || (d1 /= d2)
	then False
	else (isKDtree (Node d2 p2 te2 td2) ) && (isKDtree (Node d1 p1 te1 td1))
