module Greedy where

import Point

a::(Point Int)
a = (5,5)
b::(Point Int)
b = (6,4)
c::(Point Int)
c = (5,2)
d::(Point Int)
d = (0,0)

greedy :: [Point Int] -> [Point Int]
greedy [] = []
greedy lista = comeca (length lista) (ordena (calcula_dists lista))

calcula_dists [] = []
calcula_dists (p1:lista) = [ ((p1,p2),sqrdist (p1,p2)) | p2<-lista ] ++ (calcula_dists lista)

ordena [] = []
ordena ((pa,dista):lista) =	if null lista
				then [pa]
				else (ordena menores) ++ iguais ++ (ordena maiores)
	where
		menores = [ (p,dist) | (p,dist)<-lista , dist < dista ]
		iguais = pa:[ p | (p,dist)<-lista , dist == dista ]
		maiores = [ (p,dist) | (p,dist)<-lista , dist > dista ]

comeca tam (aresta:lista) = faz_greedy [aresta] lista tam

--faz_greedy selecionadas [] tam = comeca_tour selecionadas
faz_greedy selecionadas (a:arestas) tam =	if length selecionadas == tam-1
						then comeca_tour selecionadas
						else faz_greedy (insere a selecionadas) arestas tam

insere (p1,p2) lista =	if (ocorrencias p1 lista > 1) || (ocorrencias p2 lista > 1)
			then lista
			else	if ciclo ((p1,p2):lista)
				then lista
				else (p1,p2):lista

ciclo lista = [ (x,y) | (x,y)<-lista , ocorrencias x lista == 2 , ocorrencias y lista == 2 ] == lista

ocorrencias ponto [] = 0
ocorrencias ponto ((p1,p2):lista) =	if (p1==ponto) || (p2==ponto)
					then 1 + ocorrencias ponto lista
					else ocorrencias ponto lista

comeca_tour lista = ponta:(faz_tour ponta lista)
	where
		ponta = pega_ponta lista

pega_ponta lista =	if null ponto1
			then head [ p2 | (p1,p2)<-lista , (ocorrencias p2 lista == 1) ]
			else head ponto1
	where
		ponto1  = [ p1 | (p1,p2)<-lista , (ocorrencias p1 lista == 1) ]

faz_tour ponto [] = []
faz_tour ponto lista = a:(faz_tour a (deleta aresta lista))
	where
		(a,aresta) = pega_aresta_com ponto lista

--assumindo que sempre ha uma aresta com o ponto dado
--pega_aresta_com ponto [] = 
pega_aresta_com ponto ((p1,p2):lista) =	if p1 == ponto
					then (p2,(p1,p2))
					else	if p2 == ponto
						then (p1,(p1,p2))
						else if null lista
						then (p1,(p1,p2))
						else pega_aresta_com ponto lista

--assumindo que x sempre ocorre em a:lista
deleta x (a:lista) =	if a == x
			then lista
			else a:(deleta x lista)

