module TourEval where

import Point
import KDTree
import Binpq
import Data.List

toureval = pqgreedy

createedges [] _ = []
createedges (point:plist) kdtree =
	(dist, point, point_):(createedges plist kdtree)
	where
		newkdtree = KDTree.delete point kdtree
		point_ = KDTree.nn point newkdtree
		dist = calcdist point point_


putinqueue pq [edge] = inserl pq edge
putinqueue pq (edge:edgelist) = inserl newpq edge
	where
		newpq = putinqueue pq edgelist

pqgreedy plist = dopqgreedy pq kdtree ([p1,p2], []) (increasedegree p2 (increasedegree p1 [])) (npoints-1)
	where
		pq = putinqueue BinLeaf edgelist
		((d, p1,p2):edgelist) = createedges plist kdtree
		kdtree = build plist
		npoints = length plist

dopqgreedy _ _ semitour _ 1 = (fst semitour)
dopqgreedy pq kdtree semitour dlist npoints
	| degree_p1<=1 && degree_p2==2 =
		dopqgreedy (inserl newpq newedge1) kdtree_out_p2 semitour dlist npoints
	| degree_p1==2 =
		dopqgreedy (inserl newpq newedge3) kdtree_out_p1 semitour dlist npoints
	| degree_p1==0 && degree_p2==0 =
		dopqgreedy newpq kdtree newsemitour00 newdlist (npoints-1)
	| degree_p1==0 && degree_p2==1 =
		dopqgreedy newpq kdtree newsemitour01 newdlist (npoints-1)
	| degree_p1==1 && degree_p2==0 =
		dopqgreedy newpq kdtree newsemitour10 newdlist (npoints-1)
	| degree_p1==1 && degree_p2==1 =
		if end_p1/=p2 then
			dopqgreedy newpq kdtree newsemitour11 newdlist (npoints-1)
		else
			dopqgreedy (inserl newpq newedge2) kdtree semitour dlist npoints
	where
		(d, p1, p2) = Binpq.min pq
		newpq = (delmin pq)
		newsemitour00 = insertedge00 (p1,p2) semitour
		newsemitour01 = insertedge01 (p1,p2) semitour
		newsemitour10 = insertedge01 (p2,p1) semitour
		newsemitour11 = insertedge11 (p1,p2) semitour
		newdlist = increasedegree p2 (increasedegree p1 dlist)
		kdtree_out_p1 = KDTree.delete p1 kdtree
		kdtree_out_p2 = KDTree.delete p2 kdtree
		kdtree_out_p1p2 = KDTree.delete p2 kdtree_out_p1
		newedge1 = ((calcdist p1 npoint1), p1, npoint1)
		npoint1 = KDTree.nn p1 kdtree_out_p1p2
		newedge2 = ((calcdist p1 npoint2), p1, npoint2)
		npoint2 = KDTree.nn p1 (KDTree.delete end_p1 kdtree_out_p1p2)
		end_p1 = (end p1 semitour)
		newedge3 = ((calcdist validpoint npoint3), validpoint, npoint3)
		npoint3 = KDTree.nn validpoint (KDTree.delete validpoint kdtree_out_p1)
		validpoint = findvalidpoint dlist
		degree_p1 = (degree p1 dlist)
		degree_p2 = (degree p2 dlist)

findvalidpoint (d:dlist)
	| degree<2 =
		point
	| otherwise =
		findvalidpoint dlist
	where
		(point, degree) = d

increasedegree point [] = [(point,1)]
increasedegree point (d:dlist)
	| point==p1 =
		(point,(d1+1)):dlist
	| otherwise =
		d:(increasedegree point dlist)
	where
		(p1, d1) = d

degree point [] = 0
degree point (d:dlist)
	| point==fst(d) =
		snd(d)
	| otherwise =
		degree point dlist

insertedge00 (p1,p2) (tour, edgelist) = (tour, ((p1,p2):edgelist))

insertedge01 (p1,p2) (tour, edgelist)
	| plast == p2 =
		(tour++[p1], edgelist)
	| phead == p2 =
		(p1:tour, edgelist)
	| otherwise =
		(tour, (p1,p2):edgelist)
	where
		plast = last tour
		phead = head tour

end point semitour
	| point==(head tour) =
		doend (last tour) semitour
	| point==(last tour) =
		doend (head tour) semitour
	|otherwise =
		doend point semitour
	where
		tour = fst semitour

doend point (tour, edgelist)
	| endpoint==point =
		endpoint
	| endpoint==(head tour) =
		last tour
	| endpoint==(last tour) =
		head tour
	| otherwise =
  		endpoint
	where
		endpoint = maxrange point edgelist

insertedge11 (p1,p2) (tour, edgelist)
	| p1 == plast =
		insertedge11_at_end (p1,p2) (tour, edgelist)
	| p2 == plast =
		insertedge11_at_end (p2,p1) (tour, edgelist)
	| p1 == pfirst =
		insertedge11_at_begin (p2,p1) (tour, edgelist)
	| p2 == pfirst =
		insertedge11_at_begin (p1,p2) (tour, edgelist)
	| otherwise =
		(tour, (p1,p2):edgelist)
	where
		plast = last tour
		pfirst = head tour

insertedge11_at_begin (p1,p2) (tour, edgelist) = fixuptour_at_begin p1 (p1:tour, edgelist)

fixuptour_at_begin p1 (tour, edgelist)
	| nextedge==[] =
		(tour, edgelist)
	| otherwise =
		if (p1 == pa) then
			fixuptour_at_begin pb (pb:tour, newedgelist)
		else
			fixuptour_at_begin pa (pa:tour, newedgelist)
	where
		nextedge = findnextedge p1 edgelist
		(pa,pb) = head nextedge
		newedgelist = Data.List.delete (pa,pb) edgelist

insertedge11_at_end (p1,p2) (tour, edgelist) = fixuptour_at_end p2 (tour++[p2], edgelist)

fixuptour_at_end p1 (tour, edgelist)
	| nextedge==[] =
		(tour, edgelist)
	| otherwise =
		if (p1 == pa) then
			fixuptour_at_end pb (tour++[pb], newedgelist)
		else
			fixuptour_at_end pa (tour++[pa], newedgelist)
	where
		nextedge = findnextedge p1 edgelist
		(pa,pb) = head nextedge
		newedgelist = Data.List.delete (pa,pb) edgelist

findnextedge nextstart edgelist
	| edgelist==[] =
		[]
	| nextstart==pa || nextstart==pb =
		[(pa,pb)]
	| otherwise =
		findnextedge nextstart (tail edgelist)
	where
		(pa,pb) = head edgelist

maxrange lastpoint edgelist =
	if (nextedge == []) then
		lastpoint
	else
		if lastpoint==p2 then
			maxrange p1 newedgelist
		else
			maxrange p2 newedgelist
	where
		newedgelist = Data.List.delete (p1,p2) edgelist
		(p1,p2) = head nextedge
		nextedge = findnextedge lastpoint edgelist
