module Binpq where

data Binpq a = BinLeaf |
               Node (Binpq a) a (Binpq a)
	deriving (Show, Eq, Read)

merge BinLeaf a = a
merge a BinLeaf = a
merge (Node leftx a righty) (Node leftu b rightv)
	| a<=b =
		Node (merge righty (Node leftu b rightv)) a leftx
	| otherwise =
		Node (merge (Node leftx a righty) rightv) b leftu


inserl BinLeaf a = Node BinLeaf a BinLeaf
inserl binpq a = merge binpq (Node BinLeaf a BinLeaf)

min (Node left a right) = a

delmin BinLeaf = BinLeaf
delmin (Node left a right) = merge left right

isbinpq BinLeaf = True
isbinpq (Node BinLeaf a BinLeaf) = True
isbinpq (Node left a right)
	| right==BinLeaf =
		(root left)>a && (isbinpq left)
	| left==BinLeaf =
		(root right)>a && (isbinpq right)
	| otherwise =
		(root left)>a && (root right)>a && (isbinpq left) && (isbinpq right)
	where
		root (Node left a right) = a