module KDTree where

import Point

-- Auxiliary Functions
xcoord = fst
ycoord = snd
-- End Point --

-- Define type KDtree
data KDtree a = Leaf Bool [Point a] | No Bool Bool a (KDtree a) (KDtree a)
	deriving (Show, Eq)
-- Auxiliary functions

sort axe [] = []
sort axe (x:xs) = KDTree.sort (axe) [ s | s <- xs, axe s <= axe x] ++ [x] ++
		  KDTree.sort (axe) [ s | s <- xs, axe s > axe x ]

splitValue f v l@(x:xs) | f x > v = ([],l)
splitValue _ _ []          = ([],[])
splitValue f v (x:xs)      = (x:xs',xs'')
	where (xs',xs'') = splitValue f v xs

-- function build: let [Point a] it constructs (KDtree a)
-- True -> begin in axe x
-- Sort points in each axe
build points = _build True (KDTree.sort (xcoord) points)
			   (KDTree.sort (ycoord) points)
-- Parameters:
--	1) Boolean Value
--	2) Points sort in x
--	3) Points sort in y

_build boolean [] _ = Leaf False []
_build boolean (x:[]) _ = Leaf True [x]
_build boolean xsort ysort =
	if boolean then --it's axe x
	  	(No True
		   boolean
		   xcut
		   (_build False xtake yget)
		   (_build False xdrop yleave))
	 else -- it's axe y
	  	(No True
		   boolean
		   ycut
		   (_build True xget   ytake)
		   (_build True xleave ydrop))
	where
		-- lenght (xsort) = lenght (ysort )
		(xtake,xdrop) = splitValue (xcoord) xcut xsort
		xcut  =  div (sum ( map (xcoord) xsort ))
				--(length xsort)
				(toInteger (length xsort))

		(ytake,ydrop) = splitValue  (ycoord) ycut ysort
		ycut  =  div (sum ( map (ycoord) ysort ))
				--(length ysort)
				(toInteger (length ysort))

		xget   = [ x | x <- xsort, x `elem` ytake]
		xleave = [ x | x <- xsort, not (x `elem` ytake)]

		yget   = [ y | y <- ysort, y `elem` xtake]
		yleave = [ y | y <- ysort, not (y `elem` xtake)]

nn point kdtree = fst(nnsearch point kdtree)

nnsearch (x,y) (Leaf True [(a,b)]) = ((a,b), (calcdist (x,y) (a,b)))

nnsearch (x,y) tree@(No True axe a left right)
	| existtrees == (False, True) =
		nnsearch (x,y) right
	| existtrees == (True,False) =
		nnsearch (x,y) left
	| existtrees == (True, True) && axe =
		nnsearch_x (x,y) tree
	| existtrees == (True, True) && (not axe) =
		nnsearch_y (x,y) tree
	| otherwise =
		((999,999), 66)
	where
		existtrees = ((existtree left), (existtree right))

nnsearch_x (x,y) (No True axe a left right) =
		if (x <= a) then
			if (distl + x > a) && (distr < distl) then
				((xr,yr), distr)
			else
				((xl,yl), distl)
		else
			if (x - distr < a) && (distl < distr) then
				((xl,yl), distl)
			else
				((xr,yr), distr)
	where
		((xl,yl), distl) = nnsearch (x,y) left
		((xr,yr), distr) = nnsearch (x,y) right
		existtrees = ((existtree left), (existtree right))

nnsearch_y (x,y) (No True axe a left right) =
		if (x <= a) then
			if (distl + x > a) && (distr < distl) then
				((xr,yr), distr)
			else
				((xl,yl), distl)
		else
			if (x - distr < a) && (distl < distr) then
				((xl,yl), distl)
			else
				((xr,yr), distr)
	where
		((xl,yl), distl) = nnsearch (x,y) left
		((xr,yr), distr) = nnsearch (x,y) right
		existtrees = ((existtree left), (existtree right))

existtree (No  exist _ _ _ _) = exist
existtree (Leaf exist _) = exist

delete (x,y) (Leaf True [(a,b)])
	| (x,y) == (a,b) =
		(Leaf False [(a,b)])
	| otherwise =
		(Leaf True [(a,b)])

delete (x,y) (No True axe a left right)
	| x<=a && axe =
		if (existtree left) then
			(No existnlr axe a newleft right)
		else
			(No exist axe a left right)
	| x>a && axe =
		if (existtree right) then
			(No existlnr axe a left newright)
		else
			(No exist axe a left right)
	| y<=a =
		if (existtree left) then
			(No existnlr axe a newleft right)
		else
			(No exist axe a left right)
	| y>a =
		if (existtree right) then
			(No existlnr axe a left newright)
		else
			(No exist axe a left right)
	where
		newright = (KDTree.delete (x,y) right)
		newleft = (KDTree.delete (x,y) left)
		exist = (existtree left) || (existtree right)
		existnlr = (existtree newleft) || (existtree right)
		existlnr = (existtree left) || (existtree newright)

isKDtree tree = _isKDtree [] tree
_isKDtree restrict (Leaf _ point) =
	 foldl (&&) True [ calc r p | p<-point, r<-restrict]
	where
		calc r p = if fst r then -- axe x
				(snd r ( xcoord p))
			   else
			   	(snd r ( ycoord p))
_isKDtree restrict ( No _ boolean cut left right )
	= _isKDtree ((boolean,(cut>=)):restrict) left
	  &&
	  _isKDtree ((boolean,(cut<)):restrict) right
