module TourEval where

import Point
import Data.List

--Funo chamada pela Main
toureval = greedy

--Dada uma lista de pontos, cria todas as possveis arestas e as ordena de forma crescente
createedges plist = cleanedges (sort [((calcdist p1 p2), p1, p2)| p1 <- plist, p2 <- (subplist p1)])
	where
		subplist p1 = tail(dropWhile (/= p1) plist)
		cleanedges edgelist = [(pointa, pointb)| (dist, pointa, pointb) <- edgelist]

--npoints = numero de pontos que faltam pra fechar o tour
greedy [] = []
greedy [p1] = []
greedy [p1,p2] = [p1,p2]
greedy plist = callinsert edgelist ([p1,p2],[]) [(p1,1), (p2,1)] (npoints-1)
	where
		((p1,p2):edgelist) = createedges plist
		npoints = (length plist)

--Analisa se uma aresta pode ser inserida
callinsert _ tour _ 1 = fst tour
callinsert (edge:edgelist) tour dlist npoints
	| degree1==2 || degree2==2 =
		callinsert edgelist tour dlist npoints
	| degree1==1 && degree2==1 =
		if (end p1 tour)/=p2 then
			callinsert edgelist newtour11 newdlist (npoints-1)
		else
			callinsert edgelist tour dlist npoints
	| degree1==0 && degree2==0 =
		callinsert edgelist newtour00 newdlist (npoints-1)
	| degree1==1 =
		callinsert edgelist newtour10 newdlist (npoints-1)
	| degree2==1 =
		callinsert edgelist newtour01 newdlist (npoints-1)
	where
		newtour00 = insertedge00 (p1,p2) tour
		newtour01 = insertedge01 (p1,p2) tour
		newtour10 = insertedge01 (p2,p1) tour
		newtour11 = insertedge11 (p1,p2) tour
		newdlist = increasedegree p2 (increasedegree p1 dlist)
		degree1 = (degree p1 dlist)
		degree2 = (degree p2 dlist)
		(p1,p2) = edge

--Aumenta o grau de um ponto
increasedegree point [] = [(point,1)]
increasedegree point (d:dlist)
	| point==fst(d) =
		(point,2):dlist
	| otherwise =
		d:(increasedegree point dlist)

--Retorna o grau de um ponto
degree point [] = 0
degree point (d:dlist)
	| point==fst(d) =
		snd(d)
	| otherwise =
		degree point dlist

--Insere aresta (p1,p2) onde graus de p1 e p2 so 0 e 0
insertedge00 (p1,p2) (tour, edgelist) = (tour, ((p1,p2):edgelist))

--Insere aresta (p1,p2) onde graus de p1 e p2 so 0 e 1
insertedge01 (p1,p2) (tour, edgelist)
	| plast == p2 =
		(tour++[p1], edgelist)
	| phead == p2 =
		(p1:tour, edgelist)
	| otherwise =
		(tour, (p1,p2):edgelist)
	where
		plast = last tour
		phead = head tour

--Insere aresta (p1,p2) onde graus de p1 e p2 so 1 e 1
insertedge11 (p1,p2) (tour, edgelist)
	| p1 == plast =
		insertedge11_at_end (p1,p2) (tour, edgelist)
	| p2 == plast =
		insertedge11_at_end (p2,p1) (tour, edgelist)
	| p1 == pfirst =
		insertedge11_at_begin (p2,p1) (tour, edgelist)
	| p2 == pfirst =
		insertedge11_at_begin (p1,p2) (tour, edgelist)
	| otherwise =
		(tour, (p1,p2):edgelist)
	where
		plast = last tour
		pfirst = head tour

--Casa a nova aresta com o comeo do tour
insertedge11_at_begin (p1,p2) (tour, edgelist) = fixuptour_at_begin p1 (p1:tour, edgelist)
fixuptour_at_begin p1 (tour, edgelist)
	| nextedge==[] =
		(tour, edgelist)
	| otherwise =
		if (p1 == pa) then
			fixuptour_at_begin pb (pb:tour, newedgelist)
		else
			fixuptour_at_begin pa (pa:tour, newedgelist)
	where
		nextedge = findnextedge p1 edgelist
		(pa,pb) = head nextedge
		newedgelist = Data.List.delete (pa,pb) edgelist

--Casa a nova aresta com o final do tour
insertedge11_at_end (p1,p2) (tour, edgelist) = fixuptour_at_end p2 (tour++[p2], edgelist)
fixuptour_at_end p1 (tour, edgelist)
	| nextedge==[] =
		(tour, edgelist)
	| otherwise =
		if (p1 == pa) then
			fixuptour_at_end pb (tour++[pb], newedgelist)
		else
			fixuptour_at_end pa (tour++[pa], newedgelist)
	where
		nextedge = findnextedge p1 edgelist
		(pa,pb) = head nextedge
		newedgelist = Data.List.delete (pa,pb) edgelist

--Verifica at que ponto podemos chegar, na lista de arestas, partindo de um ponto inicial
maxrange lastpoint edgelist =
	if (nextedge == []) then
		lastpoint
	else
		if lastpoint==p2 then
			maxrange p1 newedgelist
		else
			maxrange p2 newedgelist
	where
		newedgelist = delete (p1,p2) edgelist
		(p1,p2) = head nextedge
		nextedge = findnextedge lastpoint edgelist

--Acha aresta que contm um ponto
findnextedge nextstart edgelist
	| edgelist==[] =
		[]
	| nextstart==pa || nextstart==pb =
		[(pa,pb)]
	| otherwise =
		findnextedge nextstart (tail edgelist)
	where
		(pa,pb) = head edgelist

--Verifica at que ponto podemos chegar, no tour, partindo de um ponto inicial
end point semitour
	| point==(head tour) =
		doend (last tour) semitour
	| point==(last tour) =
		doend (head tour) semitour
	|otherwise =
		doend point semitour
	where
		tour = fst semitour

doend point (tour, edgelist)
	| endpoint==point =
		endpoint
	| endpoint==(head tour) =
		last tour
	| endpoint==(last tour) =
		head tour
	| otherwise =
  		endpoint
	where
		endpoint = maxrange point edgelist
