module Binpq where

import Point

delete x xs = [a | a <- xs, a /= x]
delete :: (Ord a) => a -> [a] -> [a]

-- (a)

data Binpq a =
   PNull
 | PNode (Binpq a) Int (Binpq a)
   deriving Show

-- Funcao para construir a arvore de prioridade:

buildPT :: [Int] -> Binpq a
buildPT [] = PNull
buildPT xs = aux_buildPT PNull xs

aux_buildPT :: Binpq a -> [Int] -> Binpq a
aux_buildPT pt [] = pt
aux_buildPT pt (x:xs) = aux_buildPT (insert pt x) (delete x xs)

-- (b)

merge :: Binpq a -> Binpq a -> Binpq a
merge PNull ys = ys 
merge xs PNull = xs
merge (PNode xs a ys) (PNode us b vs)
  | (a < b) = (PNode (merge ys (PNode us b vs)) a xs)
  | (a >= b) = (PNode (merge (PNode xs a ys) vs) b us)

-- (c)

insert :: Binpq a -> Int -> Binpq a
insert hs x = merge hs (PNode PNull x PNull)

-- (d)

minPQ :: Binpq a -> Int
minPQ PNull = 0
minPQ (PNode xs a ys) = a

-- (e)

delmin :: Binpq a -> Binpq a
delmin (PNode xs a ys) = merge xs ys


-- -- -- -- -- -- -- --

isbinpq :: Binpq a -> Bool
isbinpq PNull = True

isbinpq (PNode PNull a PNull) = True

isbinpq (PNode (PNode us b vs) a PNull) =  if (a <= b)
				    	     then (isbinpq (PNode us b vs))
				     	     else False

isbinpq (PNode PNull a (PNode us b vs)) = if (a<=b)
				    	     then (isbinpq (PNode us b vs))
				     	     else False

isbinpq (PNode (PNode us b vs) a (PNode ws c zs)) = 
					  if ((a<=b) && (a<=c))
				 	   then (isbinpq (PNode us b vs) && isbinpq (PNode ws c zs))
				 	   else False

