module NN where

import Point
import KDTree

-- Heuristica nn

-- Utiliza algumas funcoes que foram implementadas no modulo KDTree, como por exemplo: min_dist, delete, list_dist, etc... 

nn :: [Point Int] -> [Point Int]
nn [] = []
nn xs = let p = (mais_distante xs)
	  in nn_aux (delete p xs) [p]

nn_aux :: [Point Int] -> [Point Int] -> [Point Int]
nn_aux [] xs = xs
nn_aux xs ys = let p = (min_dist (last ys) xs)
		in nn_aux (delete p xs) (ys++[p])


-- -- -- -- -- -- --

istour :: [Point Int] -> Bool
istour [x] = True
istour xs = if (loop (list_dist (head xs) (tail xs)))
	    then False
	    else istour (tail xs)


loop :: [(Int,Point Int)] -> Bool
loop [x] = False
loop xs = if (fst (head xs) >= fst (head (tail xs)))
          then True
	  else loop (delete (head (tail xs)) xs)

