module KDTree where

import Point

data KDTree a = 
   Null
 | Leaf [Point Int]
 | Node Bool Int (KDTree a) (KDTree a)
 deriving Show


-- FUNCOES AUXILIARES --
 
----------------
qSortX [] = []
qSortX xs = (qSortX (sSplitX (>) (head xs) (tail xs)))++ [(head xs)] ++ (qSortX (sSplitX (<=) (head xs) (tail xs)))


sSplitX op a [] = []
sSplitX op a x 
	| op (fst a) (fst (head x)) = [(head x)] ++ (sSplitX op a (tail x))
	| otherwise = sSplitX op a (tail x)
------------------------------------------------------------------------------------------------
qSortY [] = []
qSortY xs = (qSortY (sSplitY (>) (head xs) (tail xs)))++ [(head xs)] ++ (qSortY (sSplitY (<=) (head xs) (tail xs)))


sSplitY op a [] = []
sSplitY op a x 
	| op (snd a) (snd (head x)) = [(head x)] ++ (sSplitY op a (tail x))
	| otherwise = sSplitY op a (tail x)
----------------

max_x xs = maximum [x | (x,y) <- xs]
min_x xs = minimum [x | (x,y) <- xs]

max_y xs = maximum [y | (x,y) <- xs]
min_y xs = minimum [y | (x,y) <- xs]

pivot_x xs = div (max_x xs + min_x xs) 2
pivot_y xs = div (max_y xs + min_y xs) 2

----------------
delete x xs = [a | a <- xs, a /= x]
delete :: (Ord a) => a -> [a] -> [a]
----------------

dist a b = (fst a - fst b) ^ 2 + (snd a - snd b) ^ 2
dist :: (Ord a,Num a) => Point a -> Point a -> a
----------------

min_dist a xs = compDist (list_dist a xs)

list_dist :: Point Int -> [Point Int] -> [(Int,Point Int)]
list_dist a xs = [((dist a b), b) | b <- xs]

compDist :: [(Int,Point Int)] -> Point Int  
compDist [x] = snd x
compDist xs = if ( fst (head xs) < fst (head (tail xs)) )
		  then compDist ([head xs]++(tail (tail xs)))
		  else compDist (tail xs)

mais_distante xs = compDistMaior (list_dist (0,0) xs)

compDistMaior :: [(Int,Point Int)] -> Point Int
compDistMaior [x] = snd x
compDistMaior xs = if ( fst (head xs) > fst (head (tail xs)) )
		  then compDistMaior ([head xs]++(tail (tail xs)))
		  else compDistMaior (tail xs)


-- -- -- -- -- -- -- Build KDTree -- -- -- -- -- -- -- -- -- -- --

build [] = Null
build xs = buildKDTree xs True


build :: [Point Int] -> KDTree a

buildKDTree [] dim = Null
buildKDTree xs dim = if (length xs <= 8)
			then Leaf xs
			else if (dim == True)
		 		then let sortX = qSortX xs
		 			in ( Node True (pivot_x xs) (buildyl sortX xs) (buildyr sortX xs))
		 		else let sortY = qSortY xs
		 			in ( Node False (pivot_y xs) (buildxl sortY xs) (buildxr sortY xs))
		   
buildxl sortYs xs = (buildKDTree(take (partition_y xs) (sortYs)) True)
buildxr sortYs xs = (buildKDTree(drop (partition_y xs) (sortYs)) True)

buildyl sortXs xs = (buildKDTree(take (partition_x xs) sortXs) False)
buildyr sortXs xs = (buildKDTree(drop (partition_x xs) sortXs) False)

partition_x xs = length [x | (x,y) <- xs, x <= pivot_x xs]
partition_y xs = length [y | (x,y) <- xs, y <= pivot_y xs]

-- -- -- -- -- -- --

isKDtree :: (KDTree Int) -> Bool
isKDtree Null = True
isKDtree (Leaf xs) = True
isKDtree (Node dim part xs ys) = aux_isKDtree dim part (Node dim part xs ys) True

-- Especificacao do ultimo parametro desta funcao: True significa filho a esquerda. False significa filho a direita

aux_isKDtree coord partition Null son = True

aux_isKDtree True part (Leaf xs) True = is_ok True part xs True
aux_isKDtree True part (Leaf xs) False = is_ok True part xs False

aux_isKDtree False part (Leaf xs) True = is_ok False part xs True
aux_isKDtree False part (Leaf xs) False = is_ok False part xs False


aux_isKDtree coord partition (Node x y (Node dim part (Leaf ps) Null) xs) son =
		 if (is_ok dim part ps True)
		  then (aux_isKDtree coord partition (Node x y (Leaf ps) xs) son)
		  else False

aux_isKDtree coord partition (Node x y (Node dim part Null (Leaf ps)) xs) son = 
		if (is_ok dim part ps False)
		 then (aux_isKDtree coord partition (Node x y (Leaf ps) xs) son)
		 else False

aux_isKDtree coord partition (Node x y (Node dim part (Leaf ps) (Leaf pts)) xs) son = 
		if ((is_ok dim part ps True) &&
		    (is_ok dim part pts False))
		 then (aux_isKDtree coord partition (Node x y (Leaf (ps++pts)) xs) son)
		 else False

aux_isKDtree coord partition (Node x y xs (Node dim part (Leaf ps) Null)) son = 
		if (is_ok dim part ps True)
		  then (aux_isKDtree coord partition (Node x y xs (Leaf ps)) son)
		  else False

aux_isKDtree coord partition (Node x y xs (Node dim part Null (Leaf ps))) son =
		if (is_ok dim part ps False)
		  then (aux_isKDtree coord partition (Node x y xs (Leaf ps)) son)
		  else False

aux_isKDtree coord partition (Node x y xs (Node dim part (Leaf ps) (Leaf pts))) son = 
		if ((is_ok dim part ps True) &&
		    (is_ok dim part pts False))
		 then (aux_isKDtree coord partition (Node x y xs (Leaf (ps++pts))) son)
		 else False

aux_isKDtree coord partition (Node dim part xs ys) son = (aux_isKDtree dim part xs True) &&
						         (aux_isKDtree dim part ys False)

		 
is_ok coord part [] son = True
is_ok True part ps True = if ((fst(head ps)) <= part)
			   then (is_ok True part (tail ps) True)
			   else False
is_ok True part ps False = if ((fst(head ps)) >= part)
			    then (is_ok True part (tail ps) False)
			    else False
is_ok False part ps True = if ((snd(head ps)) <= part)
			    then (is_ok False part (tail ps) True)
			    else False
is_ok False part ps False = if ((snd(head ps)) >= part)
			     then (is_ok False part (tail ps) False)
			     else False

-- -- -- -- -- -- -- -- -- --

-- Deleta um ponto de uma KDTree.
deletePoint :: (Point Int) -> (KDTree Int) -> (KDTree Int)

deletePoint p Null = Null

deletePoint p (Leaf [x]) = if (p == x)
			   then Null
			   else Leaf [x]

deletePoint p (Leaf xs) = (Leaf (delete p xs))

deletePoint p (Node True part (Leaf xs) Null) = 
		if (length xs == 1 && p == head xs)
		then Null
		else (Leaf (delete p xs))

deletePoint p (Node True part Null (Leaf xs)) = 
		if (length xs == 1 && p == head xs)
		then Null
		else (Leaf (delete p xs))

deletePoint p (Node False part (Leaf xs) Null) = 
		if (length xs == 1 && p == head xs)
		then Null
		else (Leaf (delete p xs))

deletePoint p (Node False part Null (Leaf xs)) = 
		if (length xs == 1 && p == head xs)
		then Null
		else (Leaf (delete p xs))

deletePoint (x,y) (Node True part xs ys) = if (x <= part)
         then (Node True part (deletePoint (x,y) xs) ys)
         else (Node True part xs (deletePoint (x,y) ys))

deletePoint (x,y) (Node False part xs ys) = if (y <= part)
         then (Node False part (deletePoint (x,y) xs) ys)
         else (Node False part xs (deletePoint (x,y) ys)) 
-- -- -- -- -- -- -- -- -- -- --

-- Dado um ponto p, retorna o ponto, da KDTree, mais proximo de p.
findPoint :: (Point Int) -> (KDTree Int) -> (Point Int)

findPoint p Null = p
findPoint p xs = find_aux p (deletePoint p xs)

find_aux :: (Point Int) -> (KDTree Int) -> (Point Int)
find_aux p Null = p

find_aux p (Leaf xs) = min_dist p xs

find_aux p (Node dim part (Leaf []) xs) = find_aux p xs
find_aux p (Node dim part xs (Leaf [])) = find_aux p xs

find_aux p (Node True part xs ys) =
   if (fst p <= part)
   then let p1 = (find_aux p xs)
         in
        if ((dist p p1) <= (part - fst p))
        then p1
        else (menor_dist p p1 (find_aux p ys))
   else let p2 = (find_aux p ys)
        in
       if ((dist p p2) <= (fst p - part))
       then p2
       else (menor_dist p p2 (find_aux p xs))
find_aux p (Node False part xs ys) =
   if (snd p <= part)
   then let p1 = (find_aux p xs)
         in
        if ((dist p p1) <= (part - snd p))
        then p1
        else (menor_dist p p1 (find_aux p ys))
   else let p2 = (find_aux p ys)
        in
       if ((dist p p2) <= (snd p - part))
       then p2
       else (menor_dist p p2 (find_aux p xs))

menor_dist p0 p1 p2 = if (dist p0 p1 <= dist p0 p2)
   then p1
   else p2


-- -- -- -- -- -- -- -- -- --
