module Greedy where

import Point
import KDTree


-- Heuristica Greedy
{-
greedy :: [Point Int] -> [Point Int]
greedy [] = []
greedy [x] = [x]
greedy xs = let ys = arestas xs 
	     in aux_greedy (tail ys) ([parametro (head ys)]) 

aux_greedy :: [(Point Int, Point Int)] -> [[Point Int]] -> [Point Int]

aux_greedy [] aux = head aux
aux_greedy xs aux = 	if se_eh_meio (aux) (head xs)
			then aux_greedy (tail xs) ( aux )
			else aux_greedy (tail xs) (sub_tour (head xs) aux [] )

se_eh_meio [] par = False
se_eh_meio ys par = let xs = init (tail(head ys))
		    in 	if (elem (fst par) xs || elem (snd par) xs )
		    	then True
		    	else se_eh_meio (tail ys) par 

concatena2 ys x =  if (fst x == last ys)
		  	then ys ++ [snd x]
			else ys ++ [fst x]

concatena3 ys x =  if (fst x == head ys)
		  	then [snd x] ++ ys
			else [fst x] ++ ys

sub_tour par [] aux2 = ([parametro par]++aux2) 
sub_tour par aux aux2 =	if ( (last(head aux)) == (fst par) || (last(head aux)) == (snd par))
			then  let t1=concatena2 (head aux) par
			      in if (head t1 == last t1) 
				 then (aux2 ++ aux)
				 else se_fecha1 (t1) (tail aux) aux2
			else	if (head(head aux) == (fst par) || (head (head aux)) == (snd par))
				then	let t2 = concatena3 (head aux) par
					in if (head t2 == last t2)  
					   then (aux2 ++ aux)
					   else se_fecha2 (t2) (tail aux) aux2
			else sub_tour (par) (tail aux) (aux2 ++[head aux])

se_fecha1 ys [] aux2 = aux2 ++ [ys]
se_fecha1 ys aux aux2 = if (last ys == head (head aux))
		  	 	then aux2++[(init ys ++ (head aux))]++(tail aux)
		  	 	else if (last ys == last (head aux))
					then aux2++[(init ys ++ (reverse(head aux)))]++(tail aux)
					else se_fecha1 ys (tail aux) (aux2 ++[head aux])

se_fecha2 ys [] aux2 = aux2 ++ [ys]
se_fecha2 ys aux aux2 = if (head ys == head (head aux))
		  	 	then aux2++[(reverse(tail ys) ++ (head aux))]++(tail aux)
		  	 	else if (head ys == last (head aux))
					then aux2++[(head aux)++(tail ys)]++(tail aux)
					else se_fecha2 ys (tail aux) (aux2 ++[head aux])

parametro (x,y) = [x,y] 

arestas xs = [b | (a,b) <- ordena xs]
arestas :: [Point Int] -> [(Point Int, Point Int)]

ordena xs = qSortX (arestas_aux xs)

arestas_aux [] = []
arestas_aux xs =  (list_arestas (head xs) (tail xs)) ++ arestas_aux (tail xs)
arestas_aux :: [Point Int] -> [(Int,(Point Int, Point Int))]

list_arestas a xs = [((dist a b), (a,b)) | b <- xs ]
list_arestas :: Point Int -> [Point Int] -> [(Int,(Point Int, Point Int))]
  -}
  
greedy :: [Point Int] -> [Point Int]
greedy [] = []
greedy [x] = [x]
greedy xs = let ys = arestas xs 
	     in aux_greedy (tail ys) ([parametro (head ys)]) 

aux_greedy :: [(Point Int, Point Int)] -> [[Point Int]] -> [Point Int]

aux_greedy [] aux = head aux
aux_greedy xs aux = 	if se_eh_meio (aux) (head xs)
			then aux_greedy (tail xs) ( aux )
			else aux_greedy (tail xs) (sub_tour (head xs) aux )

se_eh_meio [] par = False
se_eh_meio ys par = let xs = init (tail(head ys))
		    in 	if (elem (fst par) xs || elem (snd par) xs )
		    	then True
		    	else se_eh_meio (tail ys) par 

concatena2 ys x =  if (fst x == last ys)
		  	then ys ++ [snd x]
			else ys ++ [fst x]

concatena3 ys x =  if (fst x == head ys)
		  	then [snd x] ++ ys
			else [fst x] ++ ys

sub_tour par []  = [parametro par] 
sub_tour par aux =	if ( (last(head aux)) == (fst par) || (last(head aux)) == (snd par))
			then  let t1=concatena2 (head aux) par
			      in if (head t1 == last t1) 
				 then aux
				 else (se_fecha1 (t1) (tail aux)) 
			else	if (head(head aux) == (fst par) || (head (head aux)) == (snd par))
				then	let t2 = concatena3 (head aux) par
					in if (head t2 == last t2)  
					   then aux
					   else (se_fecha2 (t2) (tail aux))
			else [head aux]++(sub_tour (par) (tail aux))

se_fecha1 ys [] = [ys]
se_fecha1 ys aux = if (last ys == head (head aux))
		  	 	then [(init ys ++ (head aux))]++(tail aux)
		  	 	else if (last ys == last (head aux))
					then [(init ys ++ (reverse(head aux)))]++(tail aux)
					else [head aux]++ (se_fecha1 ys (tail aux) )

se_fecha2 ys [] = [ys]
se_fecha2 ys aux  = if (head ys == head (head aux))
		  	 	then [(reverse(tail ys) ++ (head aux))]++(tail aux)
		  	 	else if (head ys == last (head aux))
					then [(head aux)++(tail ys)]++(tail aux)
					else [head aux]++(se_fecha2 ys (tail aux)) 

parametro (x,y) = [x,y] 
--parametro :: (Point Int, Point Int) -> [Point Int]

arestas xs = [b | (a,b) <- ordena xs]
arestas :: [Point Int] -> [(Point Int, Point Int)]

ordena xs = qSortX (arestas_aux xs)

arestas_aux [] = []
arestas_aux xs =  (list_arestas (head xs) (tail xs)) ++ arestas_aux (tail xs)
arestas_aux :: [Point Int] -> [(Int,(Point Int, Point Int))]

list_arestas a xs = [((dist a b), (a,b)) | b <- xs ]
list_arestas :: Point Int -> [Point Int] -> [(Int,(Point Int, Point Int))]

  
  
