module FRP where

import Point
import KDTree
import NN

frp :: [Point Int]->[Point Int]
frp xs = mergefrp (build xs)

mergefrp :: KDTree Int -> [Point Int]
mergefrp Null = []
mergefrp (Leaf xs) = nn xs
mergefrp (Node bool i (Leaf xs) (Leaf ys)) = if (dist (head xs) (head ys) < dist (last xs) (head ys))
						then if (dist (head xs) (head ys) <= dist (head xs) (last ys))
						      then (reverse xs ++ ys)
						      else (ys ++ xs)
						else if (dist (last xs) (head ys) <= dist (last xs) (last ys))
						      then (xs ++ ys)
						      else (xs ++ (reverse ys))
mergefrp (Node bool i xs ys) = mergefrp xs ++ mergefrp ys
