module Binpq where

data Binpq a =  Leaf 
             | Node (Binpq a) a (Binpq a)

merge (Node x a y) Leaf = (Node x a y)
merge Leaf (Node x a y) = (Node x a y)
merge (Node x a y) (Node l b r)
  | a < b = Node (merge y (Node l b r)) a x
  | a >= b = Node (merge (Node x a y) r) b l

insert (Leaf ) x = Node Leaf x Leaf
insert (Node x a y) b = merge (Node x a y) (Node Leaf b Leaf)


minpq Leaf = 0
minpq (Node (x) a (y)) = a

delmin Leaf = Leaf
delmin (Node x a y) = merge x y
