module NN where

import Data.Array
import Data.Maybe
import List
import Point
import System.Random 

import Debug.Trace
import Control.Exception
import Ordena



nn_dist_p_p (x,y) (a,b) = (a - x)*(a - x) + (b - y)*(b - y)

--calcula a distancia de um ponto ao resto da lista
nn_dist (x,y) xs = [((a,b),nn_dist_p_p (x,y) (a,b)) | (a,b) <- xs]

-- ordena os pontos em ordem crescente de distancia
nn_dist_ordenada xs = ordena_y ((nn_dist (head xs) (tail xs)))

-- escolhe um ponto "aleatoriamente" e gera uma lista ordenada de acordo com a distancia dos outros pontos ao
-- escolhido aleatoriamente
first_ptos_ord_nn_dist xs = (head (lista_ptos xs)):[x | (x,y) <- nn_dist_ordenada (lista_ptos xs)]

-- gera uma lista ordenada de acordo com a distancia do primeiro ponto aos outros pontos da lista
ptos_ord_nn_dist xs = (head (xs)):[x | (x,y) <- nn_dist_ordenada (xs)]

-- chama recursivamente a funcao acima
aux_nn [] = []
aux_nn xs =  (head (ptos_ord_nn_dist xs)) : aux_nn (tail (ptos_ord_nn_dist xs))

-- retira o ponto escolhido aleatoriamente e chama aux_nn para os demais
nn xs =  (head (first_ptos_ord_nn_dist xs)) : aux_nn (tail (first_ptos_ord_nn_dist xs))



lista_ptos xs = lista_rand xs
lista_rand xs = ptRand xs : (delete (ptRand xs) xs)
ptRand xs = xs !! (rand xs)
seed :: Int
seed = 60
rand xs= head (randomRs (0,(length xs)-1) (mkStdGen seed))
