module NNKDTree where

import Data.List
import Point
import KDTree
import NN



nn_min a b c = if nn_dist_p_p a b <= nn_dist_p_p a c
               then b
               else c


nn_kdtree (a,b) (Node bool_coord n (Leaf x) (Leaf y)) = min (a,b) (head (delete (a,b) [(e,f)|((e,f),d)<-(dist_ordenada (a,b) y)])) (head (delete (a,b) [(e,f)|((e,f),d)<-(dist_ordenada (a,b) x)]))
                                                        

nn_kdtree (a,b) (Node bool_coord n (Leaf x) y) = if bool_coord 
                                                 then if a > n
                                                      then nn_kdtree (a,b) y
                                                      else  (head (delete (a,b) [(e,f)|((e,f),d)<-(dist_ordenada (a,b) x)]))
                                                 else if b > n
                                                      then nn_kdtree (a,b) y
                                                      else  (head (delete (a,b) [(e,f)|((e,f),d)<-(dist_ordenada (a,b) x)]))

nn_kdtree (a,b) (Node bool_coord n x (Leaf y)) = if bool_coord 
                                                 then if a > n
                                                      then  (head (delete (a,b) [(e,f)|((e,f),d)<-(dist_ordenada (a,b) y)]))
                                                      else nn_kdtree (a,b) x
                                                 else if b > n
                                                      then (head (delete (a,b) [(e,f)|((e,f),d)<-(dist_ordenada (a,b) y)]))
                                                      else nn_kdtree (a,b) x



nn_kdtree (a,b) t@(Node bool_coord n x y) = if bool_coord
                                            then if a > n 
                                                 then nn_kdtree (a,b) y
                                                 else nn_kdtree (a,b) x
                                            else if b > n
                                                 then nn_kdtree (a,b) y
                                                 else nn_kdtree (a,b) x 



