module KDTree where

import Data.Array
import Data.Maybe
import List
import Point
import Debug.Trace
import Control.Exception
import Ordena

data Kdtree a =  Leaf [Point a]
               | Node Bool a (Kdtree a) (Kdtree a)

build xs = aux_build True xs  

aux_build coord xs = if (length xs <= 8) 
                     then Leaf xs
                     else if (coord )
                          then Node coord (corte_x xs) (aux_build (not coord) (ordena_x (menores_igual_x xs (corte_x xs)))) (aux_build (not coord) (ordena_x (maiores_x xs (corte_x xs))))
                          else Node coord (corte_y xs) (aux_build (not coord) (ordena_y (menores_igual_y xs (corte_y xs)))) (aux_build (not coord) (ordena_y (maiores_y xs (corte_y xs))))

troca booleano= not booleano 

corte_x xs = div (soma_x xs) (tamanho xs)
corte_y xs = div (soma_y xs) (tamanho xs)
menores_igual_x xs a = [(x,y)|(x,y)<-xs,x <= a]
menores_igual_y xs a = [(x,y)|(x,y)<-xs,y <= a]
maiores_x xs a = [(x,y)|(x,y)<-xs,x > a]
maiores_y xs a = [(x,y)|(x,y)<-xs,y > a]

mostra_x (Leaf xs) = xs
mostra_x (Node a b x y) = mostra_x x

mostra_y (Leaf xs) = xs
mostra_y (Node a b x y) = mostra_y y



soma_x xs = sum [x|(x,y)<-xs]
soma_y xs = sum [y|(x,y)<-xs]

tamanho :: [a] -> Integer
tamanho [] = 0
tamanho (x:xs) = 1 + tamanho xs

--
