module PQ where

import Point

--------------------------------------------------------------------------------
-- Definicoes para a filia de prioridade de arestas

data PQ a =
   LeafPQ
 | Node2PQ (PQ a) (Point a, Point a, a) (PQ a)
 deriving (Eq, Read, Show)

--------------------------------------------------------------------------------
-- Faz o merge de duas PQs

mergePQ LeafPQ LeafPQ = LeafPQ

mergePQ LeafPQ b = b

mergePQ a LeafPQ = a

mergePQ h1@(Node2PQ x (p1, p2, a) y) h2@(Node2PQ u (p3, p4, b) v) =
   if a < b
   then (Node2PQ (mergePQ y h2) (p1, p2, a) x)
   else (Node2PQ (mergePQ h1 v) (p3, p4, b) u)

--------------------------------------------------------------------------------
-- Insere um elemento numa PQ

insertPQ h x = mergePQ (Node2PQ LeafPQ x LeafPQ) h

--------------------------------------------------------------------------------
-- Retorna o minimo de uma PQ

minPQ LeafPQ = error "\nErro PQ.035 -> O Caixeiro Viajante esperou por muito tempo"

minPQ (Node2PQ _ a _ ) = a

--------------------------------------------------------------------------------
-- Exclui o valor minimo de uma PQ

delMinPQ LeafPQ = error "\nErro PQ.042 -> O Caixeiro Viajante esperou por muito tempo"

delMinPQ (Node2PQ a _ b) = mergePQ a b

--------------------------------------------------------------------------------
-- Funcao para validar a PQ

verifyPQ key LeafPQ = True

verifyPQ key (Node2PQ LeafPQ (_, _, a) LeafPQ) = key <= a

verifyPQ key (Node2PQ x (_, _, a) y) =
   (key <= a) && (verifyPQ key x) && (verifyPQ key y)

isbinpq LeafPQ = True
isbinpq (Node2PQ LeafPQ _ LeafPQ) = True

isbinpq (Node2PQ x (_, _, a) y) =
   (verifyPQ a x) && (verifyPQ a y) &&
   (isbinpq x) && (isbinpq y)
