module Binpq where

--------------------------------------------------------------------------------
-- Definicoes para a filia de prioridade de arestas

data PQ a =
   Leaf
 | Node2 (PQ a) a (PQ a)
 deriving (Eq, Read, Show)

--------------------------------------------------------------------------------
-- Faz o merge de duas PQs

merge Leaf Leaf = Leaf

merge Leaf b = b

merge a Leaf = a

merge h1@(Node2 x a y) h2@(Node2 u b v) =
   if a < b
   then (Node2 (merge y h2) a x)
   else (Node2 (merge h1 v) b u)

--------------------------------------------------------------------------------
-- Insere um elemento numa PQ

insert h x = merge (Node2 Leaf x Leaf) h

--------------------------------------------------------------------------------
-- Retorna o minimo de uma PQ

min Leaf = error "\nErro PQ.035 -> O Caixeiro Viajante esperou por muito tempo"

min (Node2 _ a _ ) = a

--------------------------------------------------------------------------------
-- Exclui o valor minimo de uma PQ

delMin Leaf = error "\nErro PQ.042 -> O Caixeiro Viajante esperou por muito tempo"

delMin (Node2 a _ b) = merge a b

--------------------------------------------------------------------------------
-- Funcao para validar a PQ

verify key Leaf = True

verify key (Node2 Leaf (_, _, a) Leaf) = key <= a

verify key (Node2 x (_, _, a) y) =
   (key <= a) && (verify key x) && (verify key y)

isbinpq Leaf = True
isbinpq (Node2 Leaf _ Leaf) = True

isbinpq (Node2 x (_, _, a) y) =
   (verify a x) && (verify a y) &&
   (isbinpq x) && (isbinpq y)
