module Main where

import Point
import Control.Exception
import System.CPUTime

import KDtree
import Accept

main = readIntPts [] >>= \pts -> let tour = if accept pts
                                            then nn pts
                                            else error "#012.NN -> O Caixeiro Viajante nao consegue entender o mapa (input invalido)"
                                 in putStr (showPoints (tour))

--------------------------------------------------------------------------------
-- Implementacao da heuristica NN

nnAux p _ 1 = [p]

nnAux p tree lim =
   p:(nnAux np (delete p tree) (lim - 1))
   where np = nearSearch p tree

nn [] = error "#024.NN -> O Caixeiro Viajante nao tem para onde ir"

nn [x] = [x]

nn [x, y] = [x, y]

nn [x, y, z] = [x, y, z]

nn (p:ps) =
   p:(nnAux np (delete np tree) (length ps))
   where tree = build ps
         np = nearSearch p tree
