module Main where

import Point
import Control.Exception
import System.CPUTime

import Accept
import Distance
import EdgeSort

main = readIntPts [] >>= \pts -> let tour = if accept pts
                                            then greedy pts
                                            else error "\nErro Greedy.013 -> O Caixeiro Viajante nao consegue entender o mapa (input invalido)"
                                 in putStr (showPoints (tour))

--------------------------------------------------------------------------------
-- Dado um ponto (pt) e uma lista de pontos, cria uma lista com todas as
-- arestas em pt

edges pt [] = []

edges pt [p] = [(pt, p, simpleDistance pt p)]

edges pt (p:ps) = (pt, p, simpleDistance pt p):(edges pt ps)

--------------------------------------------------------------------------------
-- Dada uma lista de pontos cria uma lista com todas as arestas possiveis

allEdges [] = []

allEdges [p] = []

allEdges (p:ps) = (edges p ps) ++ (allEdges ps)

------------------------------------------------------------------------------
-- Determina o se um ponto atingiu o grau maximo permitido num tour

occur pt [] = False

occur pt (p:ps) =
   if pt == p
   then True
   else occur pt ps

degreeBound pt [] = False

degreeBound pt (t:ts) =
   (occur pt es) || (degreeBound pt ts)
   where (es, _) = t

--------------------------------------------------------------------------------
-- Um tour pode ter varios pedacos desconectados, cada pedaco do tour
-- e representado como ([Point a], [Point a, Point a])
--                     ([meio], [inicio, fim]) <=> [inicio] ++ [meio] ++ [fim]

--------------------------------------------------------------------------------
-- Tenta conectar um pedaco de tour a um dos outros pecacos do tour

merge piece [] = [piece]

merge piece@(a, [i1, f1]) (p:ps)
   | i1 == i2 = ((reverse a) ++ (i2:b), [f1, f2]):ps
   | i1 == f2 = (b ++ (i1:a), [i2, f1]):ps
   | f1 == i2 = (a ++ (i2:b), [i1, f2]):ps
   | f1 == f2 = (a ++ (f2:(reverse b)), [i1, i2]):ps
   | otherwise = p:(merge piece ps)
   where (b, [i2, f2]) = p

--------------------------------------------------------------------------------
-- Faz o merge de varios pedacos

data ConnectPiece a =
   Discard
 | ConnectOK(a)
 deriving (Eq, Read, Show)

connectPiece (a, b) [] = error "\nErro Greedy.076 -> O Caixeiro Viajante se perdeu"

connectPiece (a, b) [t] = Discard

connectPiece (j, k) tour@(p1:(p2:ps))
   | ((j == i1) && (k == i2)) ||
     ((k == i1) && (j == i2)) = ConnectOK(((reverse a) ++ (i1:(i2:b)), [f1, f2]):ps)
   | ((j == i1) && (k == f2)) ||
     ((k == i1) && (j == f2)) = ConnectOK((b ++ (f2:(i1:a)), [i2, f1]):ps)
   | ((j == f1) && (k == i2)) ||
     ((k == f1) && (j == i2)) = ConnectOK((a ++ (f1:(i2:b)), [i1, f2]):ps)
   | ((j == f1) && (k == f2)) ||
     ((k == f1) && (j == f2)) = ConnectOK((a ++ (f1:(f2:(reverse b))), [i1, i2]):ps)
   | otherwise = case (connectPiece (j, k) (p2:ps)) of
                 ConnectOK(newTour) -> ConnectOK(p1:newTour)
                 Discard -> Discard
   where (a, [i1, f1]) = p1
         (b, [i2, f2]) = p2

mergeTour [] _ _ = error "\nErro Greedy.095 -> O Caixeiro Viajante se perdeu"

mergeTour _ tour 1 = tour

mergeTour (e:es) tour lim =
   case (connectPiece (j, k) tour) of
   ConnectOK(newTour) -> mergeTour es newTour (lim - 1)
   Discard -> mergeTour es tour lim
   where (j, k, _) = e

--------------------------------------------------------------------------------
-- Tenta inserir uma aresta num tour

insertEdge (a, b) [] = [([], [a, b])]

insertEdge (a, b) tour@(p:ps)
   | a == i = if b /= f
              then merge ((i:es), [b, f]) ps
              else tour
   | a == f = if b /= i
              then merge (es ++ [f], [i, b]) ps
              else tour
   | b == i = merge ((i:es), [a, f]) ps
   | b == f = merge (es ++ [f], [i, a]) ps
   | otherwise = p:(insertEdge (a, b) ps)
   where (es, [i, f]) = p

--------------------------------------------------------------------------------
-- Calcula o tamanho de um tour

pieceLength (ps, _) = 2 + (length ps)

tourLength [] = 0

tourLength (t:ts) = (pieceLength t) + (tourLength ts)

--------------------------------------------------------------------------------
-- Implementacao  da heuristica Greedy

greedyAux [] tour lim = error "\nErro Greedy.134 -> O Caixeiro Viajante se perdeu"

greedyAux (e:es) tour lim
   | (tourLength tour) > lim = error "\nErro Greedy.137 -> O Caixeiro Viajante se perdeu"
   | (tourLength tour) == lim = mergeTour (e:es) tour (length tour)
   | (degreeBound a tour) || (degreeBound b tour) = greedyAux es tour lim
   | otherwise = greedyAux es newTour lim
   where (a, b, _) = e
         newTour = insertEdge (a, b) tour

greedy [] = error "\nErro Greedy.144 -> O Caixeiro Viajante nao tem para onde ir"

greedy [x] = [x]

greedy [x, y] = [x, y]

greedy [x, y, z] = [x, y, z]

greedy ps =
   ts ++ [f, i]
   where [(ts, [i, f])] = (greedyAux (sort (allEdges ps)) [] (length ps))
