module PointSort where

cX (x, y) = x
cY (x, y) = y

insertOX [] q = [q]

insertOX (p:ps) q =
   if (cX q) <= (cX p)
   then q:(p:ps)
   else p:(insertOX ps q)

insertOY [] q = [q]

insertOY (p:ps) q =
   if (cY q) <= (cY p)
   then q:(p:ps)
   else p:(insertOY ps q)

insertionSortX [] = []

insertionSortX (p:ps) = insertOX (insertionSortX ps) p

insertionSortY [] = []

insertionSortY (p:ps) = insertOY (insertionSortY ps) p

quickSortX [] = []

quickSortX (p:ps) =
   if (length ps > 20)
   then (quickSortX [u | u <- ps, (cX u) < key]) ++
        (p:((quickSortX [u | u <- ps, (cX u) >= key])))
   else (p:ps)
   where key = cX p

quickSortY [] = []

quickSortY (p:ps) =
   if (length ps > 20)
   then (quickSortY [u | u <- ps, (cY u) < key]) ++
        (p:((quickSortY [u | u <- ps, (cY u) >= key])))
   else (p:ps)

   where key = cY p

sortX ps = insertionSortX (quickSortX ps)

sortY ps = insertionSortY (quickSortY ps)
