module KDtree where

import Point
import PointSort
import Distance

--------------------------------------------------------------------------------
-- Funcao que particiona no meio (ou proximo do meio) uma lista de pontos

splitX _ [] = ([], [], [])

splitX key (p:ps)
   | (cX p) < key = (p:a, b, c)
   | (cX p) == key = (a, p:b, c)
   | otherwise = (a, b, p:c)
   where (a, b, c) = splitX key ps

splitY _ [] = ([], [], [])

splitY key (p:ps)
   | (cY p) < key = (p:a, b, c)
   | (cY p) == key = (a, p:b, c)
   | otherwise = (a, b, p:c)
   where (a, b, c) = splitY key ps

data Partition a =
   PartitionOk([Point a], [Point a], [Point a], a)
 | FirstEqual([Point a], [Point a], a)
 | LastEqual([Point a], [Point a], a)
 | AllEqual
 deriving (Eq, Read, Show)

partitionX [] = error "\nErro KDtree.033 -> O Caixeiro Viajante caiu da arvore"

partitionX ps
   | (a == []) && (c == []) = AllEqual
   | a == [] = FirstEqual(b, c, key)
   | c == [] = LastEqual(a, b, key)
   | otherwise = PartitionOk(a, b, c, key)
   where key = cX (ps!!(div ((length ps) - 1) 2))
         (a, b, c) = splitX key ps

partitionY [] = error "\nErro KDtree.043 -> O Caixeiro Viajante caiu da arvore"

partitionY ps
   | (a == []) && (c == []) = AllEqual
   | a == [] = FirstEqual(b, c, key)
   | c == [] = LastEqual(a, b, key)
   | otherwise = PartitionOk(a, b, c, key)
   where key = cY (ps!!(div ((length ps) - 1) 2))
         (a, b, c) = splitY key ps

--------------------------------------------------------------------------------
-- Funcao para contruir a KDtree

data KDtree a =
   LeafKD (Point a) Bool
 | Node2KD (KDtree a) a Bool (KDtree a)
 deriving (Eq, Read, Show)

buildY [] = error "\nErro KDtree.061 -> O Caixeiro Viajante caiu da arvore"

buildY [p] = (LeafKD p True)

buildY ps = case (partitionY (sortY ps)) of
               AllEqual -> buildX ps
               FirstEqual(b, c, key) ->
                  (Node2KD (buildX b) key False (buildX c))
               LastEqual(a, b, key) ->
                  (Node2KD (buildX a) (key - 1) False (buildX b))
               PartitionOk(a, b, c, key) ->
                  (Node2KD (buildX (a ++ b)) key False (buildX c))

buildX [] = error "\nErro KDtree.074 -> O Caixeiro Viajante caiu da arvore"

buildX [p] = (LeafKD p True)

buildX ps = case (partitionX (sortX ps)) of
               AllEqual -> buildY ps
               FirstEqual(b, c, key) ->
                  (Node2KD (buildY b) key True (buildY c))
               LastEqual(a, b, key) ->
                  (Node2KD (buildY a) (key - 1) True (buildY b))
               PartitionOk(a, b, c, key) ->
                  (Node2KD (buildY (a ++ b)) key True (buildY c))

build ps = buildX ps

t = [(1362,291),(1417,173),(1425,291)]

(h, i, j) = case (partitionY (sortY t)) of
                 AllEqual -> ([], [], [])
                 FirstEqual(b, c, key) -> ([], b, c)
                 LastEqual(a, b, key) -> (a, b, [])
                 PartitionOk(a, b, c, key) -> (a, b, c)

--------------------------------------------------------------------------------
-- Funcao para validar a KDtree

verifyX (LeafKD p _) key op = op (cX p) key

verifyX (Node2KD left _ _ right) key op =
   (verifyX left key op) && (verifyX right key op)

verifyY (LeafKD p _) key op = op (cY p) key

verifyY (Node2KD left _ _ right) key op =
   (verifyY left key op) && (verifyY right key op)

isKDtree (LeafKD p _) = True

isKDtree (Node2KD left v cut right) =
   if cut
   then (verifyX left v (<=)) && (verifyX right v (>)) &&
        (isKDtree left) && (isKDtree right)
   else (verifyY left v (<=)) && (verifyY right v (>)) &&
        (isKDtree left) && (isKDtree right)

--------------------------------------------------------------------------------
-- Funcao que exclui um ponto de uma KDtree

delete _ (LeafKD p _) = (LeafKD p False)

delete (x, y) (Node2KD left v cut right) =
   if coord <= v
   then (Node2KD (delete (x, y) left) v cut right)
   else (Node2KD left v cut (delete (x, y) right))
   where coord = if cut then x else y

--------------------------------------------------------------------------------
-- Funcao que encontra o vizinho mais proximo de um Ponto numa KDtree

data ClipResult a =
   NotPresent
 | Present(Point a, Point a, a)
 deriving (Eq, Read, Show)

clip p1 (LeafKD p2 present) =
   if (not present) || (p1 == p2)
   then NotPresent
   else Present(p1, p2, bound)
   where bound = simpleDistance p1 p2

clip (x, y) (Node2KD left v cut right) =
   if coord <= v
   then case (clip (x, y) left) of
        NotPresent -> clip (x, y) right
        Present(p1, p2, bound) -> Present(p1, p2, bound)
   else case (clip (x, y) right) of
        NotPresent -> clip (x, y) left
        Present(p1, p2, bound) -> Present(p1, p2, bound)
   where coord = if cut then x else y

nearSearchAux (p, np, bound) (LeafKD q present) =
   if (present && (p /= q) && (newBound < bound))
   then (p, q, newBound)
   else (p, np, bound)
   where newBound = simpleDistance p q

nearSearchAux clip1@(p1, np1, bound1) (Node2KD left v cut right) =
   let clip2@(p2, np2, bound2) = if (coord1 - bound1) <= v
                                 then nearSearchAux clip1 left
                                 else clip1
       (x2, y2) = p2
       coord2 = if cut then x2 else y2
   in if (coord2 + bound2) > v
      then nearSearchAux clip2 right
      else clip2
   where (x1, y1) = p1
         coord1 = if cut then x1 else y1


nearSearch p tree =
   case (clip p tree) of
   NotPresent -> error "\nErro KDtree.167 -> O Caixeiro Viajante se perdeu"
   Present(a, na, bound1) ->
      nb
      where (b, nb, bound2) = nearSearchAux (a, na, bound1) tree

-- nearSearchWE abrevia nearSearchWithEdge, que retorna a aresta correspondente.
nearSearchWE p tree =
   case (clip p tree) of
   NotPresent -> error "\nErro KDtree.175 -> O Caixeiro Viajante se perdeu"
   Present(a, na, bound) -> nearSearchAux (a, na, bound) tree
